/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.ArrayList;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public interface CaveVines {
    public static final VoxelShape SHAPE = Block.column(14.0, 0.0, 16.0);
    public static final BooleanProperty BERRIES = BlockStateProperties.BERRIES;

    public static InteractionResult use(Entity entity, BlockState state, Level level, BlockPos pos) {
        if (state.getValue(BERRIES).booleanValue()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!CraftEventFactory.callEntityChangeBlockEvent(entity, pos, (BlockState)state.setValue(BERRIES, false))) {
                    return InteractionResult.SUCCESS;
                }
                ArrayList<net.minecraft.world.item.ItemStack> drops = new ArrayList<net.minecraft.world.item.ItemStack>();
                Block.dropFromBlockInteractLootTable(serverLevel, BuiltInLootTables.HARVEST_CAVE_VINE, state, level.getBlockEntity(pos), null, entity, (serverLevel1, itemStack) -> drops.add((net.minecraft.world.item.ItemStack)itemStack));
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    PlayerHarvestBlockEvent event = CraftEventFactory.callPlayerHarvestBlockEvent(level, pos, player, InteractionHand.MAIN_HAND, drops);
                    if (event.isCancelled()) {
                        return InteractionResult.SUCCESS;
                    }
                    for (ItemStack itemStack2 : event.getItemsHarvested()) {
                        Block.popResource(level, pos, CraftItemStack.asNMSCopy(itemStack2));
                    }
                } else {
                    for (net.minecraft.world.item.ItemStack itemStack3 : drops) {
                        Block.popResource(level, pos, itemStack3);
                    }
                }
                float f = Mth.randomBetween(serverLevel.random, 0.8f, 1.2f);
                serverLevel.playSound(null, pos, SoundEvents.CAVE_VINES_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, f);
                BlockState blockState = (BlockState)state.setValue(BERRIES, false);
                serverLevel.setBlock(pos, blockState, 2);
                serverLevel.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(entity, blockState));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean hasGlowBerries(BlockState state) {
        return state.hasProperty(BERRIES) && state.getValue(BERRIES) != false;
    }

    public static ToIntFunction<BlockState> emission(int berries) {
        return state -> state.getValue(BlockStateProperties.BERRIES) != false ? berries : 0;
    }
}

