/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class CryingObsidianBlock
extends Block {
    public static final MapCodec<CryingObsidianBlock> CODEC = CryingObsidianBlock.simpleCodec(CryingObsidianBlock::new);

    public MapCodec<CryingObsidianBlock> codec() {
        return CODEC;
    }

    public CryingObsidianBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction random1;
        if (random.nextInt(5) == 0 && (random1 = Direction.getRandom(random)) != Direction.UP) {
            BlockPos blockPos = pos.relative(random1);
            BlockState blockState = level.getBlockState(blockPos);
            if (!state.canOcclude() || !blockState.isFaceSturdy(level, blockPos, random1.getOpposite())) {
                double d = random1.getStepX() == 0 ? random.nextDouble() : 0.5 + (double)random1.getStepX() * 0.6;
                double d1 = random1.getStepY() == 0 ? random.nextDouble() : 0.5 + (double)random1.getStepY() * 0.6;
                double d2 = random1.getStepZ() == 0 ? random.nextDouble() : 0.5 + (double)random1.getStepZ() * 0.6;
                level.addParticle(ParticleTypes.DRIPPING_OBSIDIAN_TEAR, (double)pos.getX() + d, (double)pos.getY() + d1, (double)pos.getZ() + d2, 0.0, 0.0, 0.0);
            }
        }
    }
}

