/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.redstone.RedstoneWireTurbo;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.redstone.DefaultRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.ExperimentalRedstoneWireEvaluator;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class RedStoneWireBlock
extends Block {
    public static final MapCodec<RedStoneWireBlock> CODEC = RedStoneWireBlock.simpleCodec(RedStoneWireBlock::new);
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.NORTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.EAST_REDSTONE;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.SOUTH_REDSTONE;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.WEST_REDSTONE;
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final Map<Direction, EnumProperty<RedstoneSide>> PROPERTY_BY_DIRECTION = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(Direction.NORTH, NORTH, Direction.EAST, EAST, Direction.SOUTH, SOUTH, Direction.WEST, WEST)));
    private static final int[] COLORS = Util.make(new int[16], ints -> {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.clamp(f * f * 0.7f - 0.5f, 0.0f, 1.0f);
            float f3 = Mth.clamp(f * f * 0.6f - 0.7f, 0.0f, 1.0f);
            ints[i] = ARGB.colorFromFloat(1.0f, f1, f2, f3);
        }
    });
    private static final float PARTICLE_DENSITY = 0.2f;
    private final Function<BlockState, VoxelShape> shapes;
    private final BlockState crossState;
    private final RedstoneWireEvaluator evaluator = new DefaultRedstoneWireEvaluator(this);
    public boolean shouldSignal = true;
    RedstoneWireTurbo turbo = new RedstoneWireTurbo(this);

    public MapCodec<RedStoneWireBlock> codec() {
        return CODEC;
    }

    public RedStoneWireBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any().setValue(NORTH, RedstoneSide.NONE)).setValue(EAST, RedstoneSide.NONE)).setValue(SOUTH, RedstoneSide.NONE)).setValue(WEST, RedstoneSide.NONE)).setValue(POWER, 0));
        this.shapes = this.makeShapes();
        this.crossState = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, RedstoneSide.SIDE)).setValue(EAST, RedstoneSide.SIDE)).setValue(SOUTH, RedstoneSide.SIDE)).setValue(WEST, RedstoneSide.SIDE);
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        boolean i = true;
        int i1 = 10;
        VoxelShape voxelShape = Block.column(10.0, 0.0, 1.0);
        Map<Direction, VoxelShape> map = Shapes.rotateHorizontal(Block.boxZ(10.0, 0.0, 1.0, 0.0, 8.0));
        Map<Direction, VoxelShape> map1 = Shapes.rotateHorizontal(Block.boxZ(10.0, 16.0, 0.0, 1.0));
        return this.getShapeForEachState(blockState -> {
            VoxelShape voxelShape1 = voxelShape;
            for (Map.Entry<Direction, EnumProperty<RedstoneSide>> entry : PROPERTY_BY_DIRECTION.entrySet()) {
                voxelShape1 = switch ((RedstoneSide)blockState.getValue(entry.getValue())) {
                    default -> throw new MatchException(null, null);
                    case RedstoneSide.UP -> Shapes.or(voxelShape1, (VoxelShape)map.get(entry.getKey()), (VoxelShape)map1.get(entry.getKey()));
                    case RedstoneSide.SIDE -> Shapes.or(voxelShape1, (VoxelShape)map.get(entry.getKey()));
                    case RedstoneSide.NONE -> voxelShape1;
                };
            }
            return voxelShape1;
        }, POWER);
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.apply(state);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getConnectionState(context.getLevel(), this.crossState, context.getClickedPos());
    }

    private BlockState getConnectionState(BlockGetter level, BlockState state, BlockPos pos) {
        boolean flag1;
        boolean isDot = RedStoneWireBlock.isDot(state);
        state = this.getMissingConnections(level, (BlockState)this.defaultBlockState().setValue(POWER, state.getValue(POWER)), pos);
        if (isDot && RedStoneWireBlock.isDot(state)) {
            return state;
        }
        boolean isConnected = state.getValue(NORTH).isConnected();
        boolean isConnected1 = state.getValue(SOUTH).isConnected();
        boolean isConnected2 = state.getValue(EAST).isConnected();
        boolean isConnected3 = state.getValue(WEST).isConnected();
        boolean flag = !isConnected && !isConnected1;
        boolean bl = flag1 = !isConnected2 && !isConnected3;
        if (!isConnected3 && flag) {
            state = (BlockState)state.setValue(WEST, RedstoneSide.SIDE);
        }
        if (!isConnected2 && flag) {
            state = (BlockState)state.setValue(EAST, RedstoneSide.SIDE);
        }
        if (!isConnected && flag1) {
            state = (BlockState)state.setValue(NORTH, RedstoneSide.SIDE);
        }
        if (!isConnected1 && flag1) {
            state = (BlockState)state.setValue(SOUTH, RedstoneSide.SIDE);
        }
        return state;
    }

    private BlockState getMissingConnections(BlockGetter level, BlockState state, BlockPos pos) {
        boolean flag = !level.getBlockState(pos.above()).isRedstoneConductor(level, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (((RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected()) continue;
            RedstoneSide connectingSide = this.getConnectingSide(level, pos, direction, flag);
            state = (BlockState)state.setValue(PROPERTY_BY_DIRECTION.get(direction), connectingSide);
        }
        return state;
    }

    @Override
    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction == Direction.DOWN) {
            return !this.canSurviveOn(level, neighborPos, neighborState) ? Blocks.AIR.defaultBlockState() : state;
        }
        if (direction == Direction.UP) {
            return this.getConnectionState(level, state, pos);
        }
        RedstoneSide connectingSide = this.getConnectingSide(level, pos, direction);
        return connectingSide.isConnected() == ((RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() && !RedStoneWireBlock.isCross(state) ? (BlockState)state.setValue(PROPERTY_BY_DIRECTION.get(direction), connectingSide) : this.getConnectionState(level, (BlockState)((BlockState)this.crossState.setValue(POWER, state.getValue(POWER))).setValue(PROPERTY_BY_DIRECTION.get(direction), connectingSide), pos);
    }

    private static boolean isCross(BlockState state) {
        return state.getValue(NORTH).isConnected() && state.getValue(SOUTH).isConnected() && state.getValue(EAST).isConnected() && state.getValue(WEST).isConnected();
    }

    private static boolean isDot(BlockState state) {
        return !state.getValue(NORTH).isConnected() && !state.getValue(SOUTH).isConnected() && !state.getValue(EAST).isConnected() && !state.getValue(WEST).isConnected();
    }

    @Override
    protected void updateIndirectNeighbourShapes(BlockState state, LevelAccessor level, BlockPos pos, @Block.UpdateFlags int flags, int recursionLeft) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneSide = (RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction));
            if (redstoneSide == RedstoneSide.NONE || level.getBlockState(mutableBlockPos.setWithOffset((Vec3i)pos, direction)).is(this)) continue;
            mutableBlockPos.move(Direction.DOWN);
            BlockState blockState = level.getBlockState(mutableBlockPos);
            if (blockState.is(this)) {
                Vec3i blockPos = mutableBlockPos.relative(direction.getOpposite());
                level.neighborShapeChanged(direction.getOpposite(), mutableBlockPos, (BlockPos)blockPos, level.getBlockState((BlockPos)blockPos), flags, recursionLeft);
            }
            mutableBlockPos.setWithOffset((Vec3i)pos, direction).move(Direction.UP);
            BlockState blockState1 = level.getBlockState(mutableBlockPos);
            if (!blockState1.is(this)) continue;
            Vec3i blockPos1 = mutableBlockPos.relative(direction.getOpposite());
            level.neighborShapeChanged(direction.getOpposite(), mutableBlockPos, (BlockPos)blockPos1, level.getBlockState((BlockPos)blockPos1), flags, recursionLeft);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter level, BlockPos pos, Direction face) {
        return this.getConnectingSide(level, pos, face, !level.getBlockState(pos.above()).isRedstoneConductor(level, pos));
    }

    private RedstoneSide getConnectingSide(BlockGetter level, BlockPos pos, Direction direction, boolean nonNormalCubeAbove) {
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = level.getBlockState(blockPos);
        if (nonNormalCubeAbove) {
            boolean flag;
            boolean bl = flag = blockState.getBlock() instanceof TrapDoorBlock || this.canSurviveOn(level, blockPos, blockState);
            if (flag && RedStoneWireBlock.shouldConnectTo(level.getBlockState(blockPos.above()))) {
                if (blockState.isFaceSturdy(level, blockPos, direction.getOpposite())) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !RedStoneWireBlock.shouldConnectTo(blockState, direction) && (blockState.isRedstoneConductor(level, blockPos) || !RedStoneWireBlock.shouldConnectTo(level.getBlockState(blockPos.below()))) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        return this.canSurviveOn(level, blockPos, blockState);
    }

    private boolean canSurviveOn(BlockGetter level, BlockPos pos, BlockState state) {
        return state.isFaceSturdy(level, pos, Direction.UP) || state.is(Blocks.HOPPER);
    }

    private void updateSurroundingRedstone(Level worldIn, BlockPos pos, BlockState state, @Nullable Orientation orientation, boolean blockAdded) {
        if (worldIn.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.EIGENCRAFT) {
            BlockPos source = null;
            if (orientation != null) {
                source = pos.relative(orientation.getFront().getOpposite());
            }
            this.turbo.updateSurroundingRedstone(worldIn, pos, state, source);
            return;
        }
        this.updatePowerStrength(worldIn, pos, state, orientation, blockAdded);
    }

    public BlockState calculateCurrentChanges(Level level, BlockPos pos, BlockState state) {
        int newPower;
        int oldPower = state.getValue(POWER);
        if (oldPower != (newPower = ((DefaultRedstoneWireEvaluator)this.evaluator).calculateTargetStrength(level, pos))) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), oldPower, newPower);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            newPower = event.getNewCurrent();
            if (level.getBlockState(pos) == state && level.setBlock(pos, state = (BlockState)state.setValue(POWER, newPower), 18)) {
                this.turbo.updateNeighborShapes(level, pos, state);
            }
        }
        return state;
    }

    private void updatePowerStrength(Level level, BlockPos pos, BlockState state, @Nullable Orientation orientation, boolean updateShape) {
        if (RedStoneWireBlock.useExperimentalEvaluator(level)) {
            new ExperimentalRedstoneWireEvaluator(this).updatePowerStrength(level, pos, state, orientation, updateShape);
        } else {
            this.evaluator.updatePowerStrength(level, pos, state, orientation, updateShape);
        }
    }

    public int getBlockSignal(Level level, BlockPos pos) {
        this.shouldSignal = false;
        int bestNeighborSignal = level.getBestNeighborSignal(pos);
        this.shouldSignal = true;
        return bestNeighborSignal;
    }

    private void checkCornerChangeAt(Level level, BlockPos pos) {
        if (level.getBlockState(pos).is(this)) {
            level.updateNeighborsAt(pos, this);
            for (Direction direction : Direction.values()) {
                level.updateNeighborsAt(pos.relative(direction), this);
            }
        }
    }

    @Override
    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (!oldState.is(state.getBlock()) && !level.isClientSide()) {
            if (level.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                level.getWireHandler().onWireAdded(pos, state);
            } else {
                this.updateSurroundingRedstone(level, pos, state, null, true);
            }
            for (Direction direction : Direction.Plane.VERTICAL) {
                level.updateNeighborsAt(pos.relative(direction), this);
            }
            this.updateNeighborsOfNeighboringWires(level, pos);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean movedByPiston) {
        if (!movedByPiston) {
            for (Direction direction : Direction.values()) {
                level.updateNeighborsAt(pos.relative(direction), this);
            }
            if (level.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                level.getWireHandler().onWireRemoved(pos, state);
            } else {
                this.updateSurroundingRedstone(level, pos, state, null, false);
            }
            this.updateNeighborsOfNeighboringWires(level, pos);
        }
    }

    private void updateNeighborsOfNeighboringWires(Level level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(level, pos.relative(direction));
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction);
            if (level.getBlockState(blockPos).isRedstoneConductor(level, blockPos)) {
                this.checkCornerChangeAt(level, blockPos.above());
                continue;
            }
            this.checkCornerChangeAt(level, blockPos.below());
        }
    }

    @Override
    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!level.isClientSide()) {
            if (level.paperConfig().misc.redstoneImplementation == WorldConfiguration.Misc.RedstoneImplementation.ALTERNATE_CURRENT) {
                level.getWireHandler().onWireUpdated(pos, state, orientation);
            } else if (neighborBlock != this || !RedStoneWireBlock.useExperimentalEvaluator(level)) {
                if (state.canSurvive(level, pos)) {
                    this.updateSurroundingRedstone(level, pos, state, orientation, false);
                } else {
                    RedStoneWireBlock.dropResources(state, level, pos);
                    level.removeBlock(pos, false);
                }
            }
        }
    }

    private static boolean useExperimentalEvaluator(Level level) {
        return level.enabledFeatures().contains(FeatureFlags.REDSTONE_EXPERIMENTS);
    }

    @Override
    protected int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return !this.shouldSignal ? 0 : state.getSignal(level, pos, side);
    }

    @Override
    protected int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (this.shouldSignal && side != Direction.DOWN) {
            int powerValue = state.getValue(POWER);
            if (powerValue == 0) {
                return 0;
            }
            return side != Direction.UP && !((RedstoneSide)this.getConnectionState(level, state, pos).getValue(PROPERTY_BY_DIRECTION.get(side.getOpposite()))).isConnected() ? 0 : powerValue;
        }
        return 0;
    }

    protected static boolean shouldConnectTo(BlockState state) {
        return RedStoneWireBlock.shouldConnectTo(state, null);
    }

    protected static boolean shouldConnectTo(BlockState state, @Nullable Direction direction) {
        if (state.is(Blocks.REDSTONE_WIRE)) {
            return true;
        }
        if (state.is(Blocks.REPEATER)) {
            Direction direction1 = state.getValue(HorizontalDirectionalBlock.FACING);
            return direction1 == direction || direction1.getOpposite() == direction;
        }
        return state.is(Blocks.OBSERVER) ? direction == state.getValue(DirectionalBlock.FACING) : state.isSignalSource() && direction != null;
    }

    @Override
    protected boolean isSignalSource(BlockState state) {
        return this.shouldSignal;
    }

    public static int getColorForPower(int power) {
        return COLORS[power];
    }

    private static void spawnParticlesAlongLine(Level level, RandomSource random, BlockPos pos, int color, Direction direction, Direction perpendicularDirection, float start, float end) {
        float f = end - start;
        if (!(random.nextFloat() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = start + f * random.nextFloat();
            double d = 0.5 + (double)(0.4375f * (float)direction.getStepX()) + (double)(f2 * (float)perpendicularDirection.getStepX());
            double d1 = 0.5 + (double)(0.4375f * (float)direction.getStepY()) + (double)(f2 * (float)perpendicularDirection.getStepY());
            double d2 = 0.5 + (double)(0.4375f * (float)direction.getStepZ()) + (double)(f2 * (float)perpendicularDirection.getStepZ());
            level.addParticle(new DustParticleOptions(color, 1.0f), (double)pos.getX() + d, (double)pos.getY() + d1, (double)pos.getZ() + d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int powerValue = state.getValue(POWER);
        if (powerValue != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneSide = (RedstoneSide)state.getValue(PROPERTY_BY_DIRECTION.get(direction));
                switch (redstoneSide) {
                    case UP: {
                        RedStoneWireBlock.spawnParticlesAlongLine(level, random, pos, COLORS[powerValue], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        RedStoneWireBlock.spawnParticlesAlongLine(level, random, pos, COLORS[powerValue], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                RedStoneWireBlock.spawnParticlesAlongLine(level, random, pos, COLORS[powerValue], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    @Override
    protected BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(EAST, state.getValue(WEST))).setValue(SOUTH, state.getValue(NORTH))).setValue(WEST, state.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(EAST))).setValue(EAST, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(WEST))).setValue(WEST, state.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, state.getValue(WEST))).setValue(EAST, state.getValue(NORTH))).setValue(SOUTH, state.getValue(EAST))).setValue(WEST, state.getValue(SOUTH));
            }
        }
        return state;
    }

    @Override
    protected BlockState mirror(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, state.getValue(SOUTH))).setValue(SOUTH, state.getValue(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, state.getValue(WEST))).setValue(WEST, state.getValue(EAST));
            }
        }
        return super.mirror(state, mirror);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(NORTH, EAST, SOUTH, WEST, POWER);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!player.getAbilities().mayBuild) {
            return InteractionResult.PASS;
        }
        if (RedStoneWireBlock.isCross(state) || RedStoneWireBlock.isDot(state)) {
            BlockState blockState = RedStoneWireBlock.isCross(state) ? this.defaultBlockState() : this.crossState;
            blockState = (BlockState)blockState.setValue(POWER, state.getValue(POWER));
            if ((blockState = this.getConnectionState(level, blockState, pos)) != state) {
                level.setBlock(pos, blockState, 3);
                this.updatesOnShapeChange(level, pos, state, blockState);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level level, BlockPos pos, BlockState oldState, BlockState newState) {
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(level, null, Direction.UP);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockPos = pos.relative(direction);
            if (((RedstoneSide)oldState.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() == ((RedstoneSide)newState.getValue(PROPERTY_BY_DIRECTION.get(direction))).isConnected() || !level.getBlockState(blockPos).isRedstoneConductor(level, blockPos)) continue;
            level.updateNeighborsAtExceptFromFacing(blockPos, newState.getBlock(), direction.getOpposite(), ExperimentalRedstoneUtils.withFront(orientation, direction));
        }
    }
}

