/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CampfireBlockEntity
extends BlockEntity
implements Clearable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<net.minecraft.world.item.ItemStack> items = NonNullList.withSize(4, net.minecraft.world.item.ItemStack.EMPTY);
    public final int[] cookingProgress = new int[4];
    public final int[] cookingTime = new int[4];
    public final boolean[] stopCooking = new boolean[4];

    public CampfireBlockEntity(BlockPos pos, BlockState blockState) {
        super(BlockEntityType.CAMPFIRE, pos, blockState);
    }

    public static void cookTick(ServerLevel level, BlockPos pos, BlockState state, CampfireBlockEntity campfire, RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> check) {
        boolean flag = false;
        for (int i = 0; i < campfire.items.size(); ++i) {
            SingleRecipeInput singleRecipeInput;
            Optional<RecipeHolder<CampfireCookingRecipe>> optionalCookingRecipe;
            net.minecraft.world.item.ItemStack itemStack1;
            net.minecraft.world.item.ItemStack itemStack = campfire.items.get(i);
            if (itemStack.isEmpty()) continue;
            flag = true;
            if (!campfire.stopCooking[i]) {
                int n = i;
                campfire.cookingProgress[n] = campfire.cookingProgress[n] + 1;
            }
            if (campfire.cookingProgress[i] < campfire.cookingTime[i] || !(itemStack1 = (optionalCookingRecipe = check.getRecipeFor(singleRecipeInput = new SingleRecipeInput(itemStack), level)).map(recipe -> ((CampfireCookingRecipe)recipe.value()).assemble(singleRecipeInput, (HolderLookup.Provider)level.registryAccess())).orElse(itemStack)).isItemEnabled(level.enabledFeatures())) continue;
            CraftItemStack source = CraftItemStack.asCraftMirror(itemStack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemStack1);
            BlockCookEvent blockCookEvent = new BlockCookEvent((Block)CraftBlock.at(level, pos), (ItemStack)source, result, (CookingRecipe)optionalCookingRecipe.map(RecipeHolder::toBukkitRecipe).orElse(null));
            if (!blockCookEvent.callEvent()) {
                return;
            }
            result = blockCookEvent.getResult();
            itemStack1 = CraftItemStack.asNMSCopy(result);
            double deviation = 0.11485000171139836;
            while (!itemStack1.isEmpty()) {
                ItemEntity droppedItem = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemStack1.split(level.random.nextInt(21) + 10));
                droppedItem.setDeltaMovement(level.random.triangle(0.0, deviation), level.random.triangle(0.2, deviation), level.random.triangle(0.0, deviation));
                level.addFreshEntity(droppedItem);
            }
            campfire.items.set(i, net.minecraft.world.item.ItemStack.EMPTY);
            level.sendBlockUpdated(pos, state, state, 3);
            level.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of(state));
        }
        if (flag) {
            CampfireBlockEntity.setChanged(level, pos, state);
        }
    }

    public static void cooldownTick(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity) {
        boolean flag = false;
        for (int i = 0; i < blockEntity.items.size(); ++i) {
            if (blockEntity.cookingProgress[i] <= 0) continue;
            flag = true;
            blockEntity.cookingProgress[i] = Mth.clamp(blockEntity.cookingProgress[i] - 2, 0, blockEntity.cookingTime[i]);
        }
        if (flag) {
            CampfireBlockEntity.setChanged(level, pos, state);
        }
    }

    public static void particleTick(Level level, BlockPos pos, BlockState state, CampfireBlockEntity blockEntity) {
        int i;
        RandomSource randomSource = level.random;
        if (randomSource.nextFloat() < 0.11f) {
            for (i = 0; i < randomSource.nextInt(2) + 2; ++i) {
                CampfireBlock.makeParticles(level, pos, state.getValue(CampfireBlock.SIGNAL_FIRE), false);
            }
        }
        i = state.getValue(CampfireBlock.FACING).get2DDataValue();
        for (int i1 = 0; i1 < blockEntity.items.size(); ++i1) {
            if (blockEntity.items.get(i1).isEmpty() || !(randomSource.nextFloat() < 0.2f)) continue;
            Direction direction = Direction.from2DDataValue(Math.floorMod(i1 + i, 4));
            float f = 0.3125f;
            double d = (double)pos.getX() + 0.5 - (double)((float)direction.getStepX() * 0.3125f) + (double)((float)direction.getClockWise().getStepX() * 0.3125f);
            double d1 = (double)pos.getY() + 0.5;
            double d2 = (double)pos.getZ() + 0.5 - (double)((float)direction.getStepZ() * 0.3125f) + (double)((float)direction.getClockWise().getStepZ() * 0.3125f);
            for (int i2 = 0; i2 < 4; ++i2) {
                level.addParticle(ParticleTypes.SMOKE, d, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        return this.items;
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.items.clear();
        ContainerHelper.loadAllItems(input, this.items);
        input.getIntArray("CookingTimes").ifPresentOrElse(ints -> System.arraycopy(ints, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, ((int[])ints).length)), () -> Arrays.fill(this.cookingProgress, 0));
        input.getIntArray("CookingTotalTimes").ifPresentOrElse(ints -> System.arraycopy(ints, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, ((int[])ints).length)), () -> Arrays.fill(this.cookingTime, 0));
        input.read("Paper.StopCooking", Codec.BYTE_BUFFER).ifPresent(bytes -> {
            boolean[] cookingState = new boolean[4];
            for (int index = 0; bytes.hasRemaining() && index < cookingState.length; ++index) {
                cookingState[index] = bytes.get() == 1;
            }
            System.arraycopy(cookingState, 0, this.stopCooking, 0, Math.min(this.stopCooking.length, bytes.capacity()));
        });
    }

    @Override
    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        ContainerHelper.saveAllItems(output, this.items, true);
        output.putIntArray("CookingTimes", this.cookingProgress);
        output.putIntArray("CookingTotalTimes", this.cookingTime);
        byte[] cookingState = new byte[4];
        for (int index = 0; index < cookingState.length; ++index) {
            cookingState[index] = (byte)(this.stopCooking[index] ? 1 : 0);
        }
        output.store("Paper.StopCooking", Codec.BYTE_BUFFER, ByteBuffer.wrap(cookingState));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag var4;
        try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(this.problemPath(), LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext(scopedCollector, registries);
            ContainerHelper.saveAllItems(tagValueOutput, this.items, true);
            var4 = tagValueOutput.buildResult();
        }
        return var4;
    }

    public boolean placeFood(ServerLevel level, @Nullable LivingEntity entity, net.minecraft.world.item.ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            net.minecraft.world.item.ItemStack itemStack = this.items.get(i);
            if (!itemStack.isEmpty()) continue;
            Optional<RecipeHolder<CampfireCookingRecipe>> recipeFor = level.recipeAccess().getRecipeFor(RecipeType.CAMPFIRE_COOKING, new SingleRecipeInput(stack), level);
            if (recipeFor.isEmpty()) {
                return false;
            }
            CampfireStartEvent event = new CampfireStartEvent((Block)CraftBlock.at(this.level, this.worldPosition), (ItemStack)CraftItemStack.asCraftMirror(stack), (CampfireRecipe)recipeFor.get().toBukkitRecipe());
            this.level.getCraftServer().getPluginManager().callEvent((Event)event);
            this.cookingTime[i] = event.getTotalCookTime();
            this.cookingProgress[i] = 0;
            this.items.set(i, stack.consumeAndReturn(1, entity));
            level.gameEvent(GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of(entity, this.getBlockState()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.setChanged();
        this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public void clearContent() {
        this.items.clear();
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        if (this.level != null) {
            Containers.dropContents(this.level, pos, this.getItems());
        }
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter componentGetter) {
        super.applyImplicitComponents(componentGetter);
        componentGetter.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY).copyInto(this.getItems());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CONTAINER, ItemContainerContents.fromItems(this.getItems()));
    }

    @Override
    public void removeComponentsFromTag(ValueOutput output) {
        output.discard("Items");
    }
}

