/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCDataType;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.Version;
import ca.spottedleaf.moonrise.patches.chunk_system.storage.ChunkSystemSimpleRegionStorage;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class SimpleRegionStorage
implements ChunkSystemSimpleRegionStorage,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private final RegionFileStorage storage;
    private final DataFixer fixerUpper;
    private final DataFixTypes dataFixType;
    private final Supplier<LegacyTagFixer> legacyFixer;

    public SimpleRegionStorage(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync, DataFixTypes dataFixType) {
        this(info, folder, fixerUpper, sync, dataFixType, LegacyTagFixer.EMPTY);
    }

    public SimpleRegionStorage(RegionStorageInfo info, Path folder, DataFixer fixerUpper, boolean sync, DataFixTypes dataFixType, Supplier<LegacyTagFixer> legacyFixer) {
        this.fixerUpper = fixerUpper;
        this.dataFixType = dataFixType;
        this.storage = new IOWorker((RegionStorageInfo)info, (Path)folder, (boolean)sync).storage;
        this.legacyFixer = Suppliers.memoize(legacyFixer::get);
    }

    @Override
    public final RegionFileStorage moonrise$getRegionStorage() {
        return this.storage;
    }

    public boolean isOldChunkAround(ChunkPos chunkPos, int radius) {
        return true;
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.storage.read(chunkPos)));
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    public CompletableFuture<Void> write(ChunkPos chunkPos, CompoundTag data) {
        return this.write(chunkPos, () -> data);
    }

    public CompletableFuture<Void> write(ChunkPos chunkPos, Supplier<CompoundTag> data) {
        Supplier<CompoundTag> guardedPosCheck = () -> {
            boolean chunkStorage;
            CompoundTag nbt = (CompoundTag)data.get();
            boolean bl = chunkStorage = this.dataFixType == DataFixTypes.CHUNK;
            if (chunkStorage && nbt != null && !chunkPos.equals(SerializableChunkData.getChunkCoordinate(nbt))) {
                String world = this instanceof ChunkMap ? ((ChunkMap)this).level.getWorld().getName() : null;
                throw new IllegalArgumentException("Chunk coordinate and serialized data do not have matching coordinates, trying to serialize coordinate " + String.valueOf(chunkPos) + " but compound says coordinate is " + String.valueOf(SerializableChunkData.getChunkCoordinate(nbt)) + (String)(world == null ? " for an unknown world" : " for world: " + world));
            }
            return nbt;
        };
        this.markChunkDone(chunkPos);
        try {
            this.storage.write(chunkPos, guardedPosCheck.get());
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedFuture(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundTag upgradeChunkTag(CompoundTag tag, int fallbackVersion, @Nullable CompoundTag contextTag, @Nullable LevelAccessor levelAccessor) {
        int dataVersion = NbtUtils.getDataVersion(tag, fallbackVersion);
        if (dataVersion == SharedConstants.getCurrentVersion().dataVersion().version()) {
            return tag;
        }
        try {
            boolean chunkStorage;
            LegacyTagFixer legacyFixer;
            LegacyTagFixer legacyTagFixer = legacyFixer = this.legacyFixer.get();
            synchronized (legacyTagFixer) {
                tag = legacyFixer.applyFix(tag);
            }
            boolean stopBelowZero = false;
            boolean bl = chunkStorage = this.dataFixType == DataFixTypes.CHUNK;
            if (chunkStorage) {
                boolean belowZeroGenerationInExistingChunks;
                boolean bl2 = belowZeroGenerationInExistingChunks = levelAccessor != null ? ((ServerLevel)levelAccessor).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
                if (dataVersion <= 2730 && !belowZeroGenerationInExistingChunks) {
                    stopBelowZero = "full".equals(tag.getCompound("Level").flatMap(l -> l.getString("Status")).orElse(null));
                }
            }
            SimpleRegionStorage.injectDatafixingContext(tag, contextTag);
            tag = MCDataConverter.convertTag(this.getDataConverterType(), tag, Math.max(this.legacyFixer.get().targetDataVersion(), dataVersion), Version.getCurrentVersion());
            if (stopBelowZero) {
                tag.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(ChunkStatus.SPAWN).toString());
            }
            SimpleRegionStorage.removeDatafixingContext(tag);
            NbtUtils.addCurrentDataVersion(tag);
            return tag;
        }
        catch (Exception var8) {
            CrashReport crashReport = CrashReport.forThrowable(var8, "Updated chunk");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Updated chunk details");
            crashReportCategory.setDetail("Data version", dataVersion);
            throw new ReportedException(crashReport);
        }
    }

    private MCDataType getDataConverterType() {
        if (this.dataFixType == DataFixTypes.CHUNK) {
            return MCTypeRegistry.CHUNK;
        }
        if (this.dataFixType == DataFixTypes.ENTITY_CHUNK) {
            return MCTypeRegistry.ENTITY_CHUNK;
        }
        if (this.dataFixType == DataFixTypes.POI_CHUNK) {
            return MCTypeRegistry.POI_CHUNK;
        }
        throw new UnsupportedOperationException("For " + this.dataFixType.name());
    }

    public CompoundTag upgradeChunkTag(CompoundTag tag, int version) {
        return this.upgradeChunkTag(tag, version, null, null);
    }

    public Dynamic<Tag> upgradeChunkTag(Dynamic<Tag> tag, int version) {
        return new Dynamic<Tag>(tag.getOps(), this.upgradeChunkTag((CompoundTag)tag.getValue(), version, null, null));
    }

    public static void injectDatafixingContext(CompoundTag tag, @Nullable CompoundTag contextTag) {
        if (contextTag != null) {
            tag.put("__context", contextTag);
        }
    }

    private static void removeDatafixingContext(CompoundTag tag) {
        tag.remove("__context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markChunkDone(ChunkPos chunkPos) {
        LegacyTagFixer legacyFixer;
        LegacyTagFixer legacyTagFixer = legacyFixer = this.legacyFixer.get();
        synchronized (legacyTagFixer) {
            legacyFixer.markChunkDone(chunkPos);
        }
    }

    public CompletableFuture<Void> synchronize(boolean flushStorage) {
        try {
            this.storage.flush();
            return CompletableFuture.completedFuture(null);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to flush chunk storage", (Throwable)ex);
            return CompletableFuture.failedFuture(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.storage.close();
    }

    public ChunkScanAccess chunkScanner() {
        return (chunkPos, streamTagVisitor) -> {
            try {
                this.storage.scanChunk(chunkPos, streamTagVisitor);
                return CompletableFuture.completedFuture(null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public RegionStorageInfo storageInfo() {
        return this.storage.info();
    }
}

