/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.timeline.Timeline;

public record DimensionType(boolean hasFixedTime, boolean hasSkyLight, boolean hasCeiling, double coordinateScale, int minY, int height, int logicalHeight, TagKey<Block> infiniburn, float ambientLight, MonsterSettings monsterSettings, Skybox skybox, CardinalLightType cardinalLightType, EnvironmentAttributeMap attributes, HolderSet<Timeline> timelines) {
    public static final int BITS_FOR_Y = 12;
    public static final int MIN_HEIGHT = 16;
    public static final int Y_SIZE = 4064;
    public static final int MAX_Y = 2031;
    public static final int MIN_Y = -2032;
    public static final int WAY_ABOVE_MAX_Y = 32496;
    public static final int WAY_BELOW_MIN_Y = -32512;
    public static final Codec<DimensionType> DIRECT_CODEC = DimensionType.createDirectCodec(EnvironmentAttributeMap.CODEC);
    public static final Codec<DimensionType> NETWORK_CODEC = DimensionType.createDirectCodec(EnvironmentAttributeMap.NETWORK_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DimensionType>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.DIMENSION_TYPE);
    public static final float[] MOON_BRIGHTNESS_PER_PHASE = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final Codec<Holder<DimensionType>> CODEC = RegistryFileCodec.create(Registries.DIMENSION_TYPE, DIRECT_CODEC);

    public DimensionType {
        if (height < 16) {
            throw new IllegalStateException("height has to be at least 16");
        }
        if (minY + height > 2032) {
            throw new IllegalStateException("min_y + height cannot be higher than: 2032");
        }
        if (logicalHeight > height) {
            throw new IllegalStateException("logical_height cannot be higher than height");
        }
        if (height % 16 != 0) {
            throw new IllegalStateException("height has to be multiple of 16");
        }
        if (minY % 16 != 0) {
            throw new IllegalStateException("min_y has to be a multiple of 16");
        }
    }

    private static Codec<DimensionType> createDirectCodec(Codec<EnvironmentAttributeMap> attributesCodec) {
        return ExtraCodecs.catchDecoderException(RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("has_fixed_time", (Object)false).forGetter(DimensionType::hasFixedTime), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionType::hasSkyLight), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionType::hasCeiling), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionType::coordinateScale), (App)Codec.intRange((int)-2032, (int)2031).fieldOf("min_y").forGetter(DimensionType::minY), (App)Codec.intRange((int)16, (int)4064).fieldOf("height").forGetter(DimensionType::height), (App)Codec.intRange((int)0, (int)4064).fieldOf("logical_height").forGetter(DimensionType::logicalHeight), (App)TagKey.hashedCodec(Registries.BLOCK).fieldOf("infiniburn").forGetter(DimensionType::infiniburn), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(DimensionType::ambientLight), (App)MonsterSettings.CODEC.forGetter(DimensionType::monsterSettings), (App)Skybox.CODEC.optionalFieldOf("skybox", (Object)Skybox.OVERWORLD).forGetter(DimensionType::skybox), (App)CardinalLightType.CODEC.optionalFieldOf("cardinal_light", (Object)CardinalLightType.DEFAULT).forGetter(DimensionType::cardinalLightType), (App)attributesCodec.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.EMPTY).forGetter(DimensionType::attributes), (App)RegistryCodecs.homogeneousList(Registries.TIMELINE).optionalFieldOf("timelines", HolderSet.empty()).forGetter(DimensionType::timelines)).apply((Applicative)instance, DimensionType::new)));
    }

    public static double getTeleportationScale(DimensionType firstType, DimensionType secondType) {
        double coordinateScale = firstType.coordinateScale();
        double coordinateScale1 = secondType.coordinateScale();
        return coordinateScale / coordinateScale1;
    }

    public static Path getStorageFolder(ResourceKey<Level> dimensionKey, Path levelFolder) {
        if (dimensionKey == Level.OVERWORLD) {
            return levelFolder;
        }
        if (dimensionKey == Level.END) {
            return levelFolder.resolve("DIM1");
        }
        return dimensionKey == Level.NETHER ? levelFolder.resolve("DIM-1") : levelFolder.resolve("dimensions").resolve(dimensionKey.identifier().getNamespace()).resolve(dimensionKey.identifier().getPath());
    }

    public IntProvider monsterSpawnLightTest() {
        return this.monsterSettings.monsterSpawnLightTest();
    }

    public int monsterSpawnBlockLightLimit() {
        return this.monsterSettings.monsterSpawnBlockLightLimit();
    }

    public boolean hasEndFlashes() {
        return this.skybox == Skybox.END;
    }

    public record MonsterSettings(IntProvider monsterSpawnLightTest, int monsterSpawnBlockLightLimit) {
        public static final MapCodec<MonsterSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.codec(0, 15).fieldOf("monster_spawn_light_level").forGetter(MonsterSettings::monsterSpawnLightTest), (App)Codec.intRange((int)0, (int)15).fieldOf("monster_spawn_block_light_limit").forGetter(MonsterSettings::monsterSpawnBlockLightLimit)).apply((Applicative)instance, MonsterSettings::new));
    }

    public static enum Skybox implements StringRepresentable
    {
        NONE("none"),
        OVERWORLD("overworld"),
        END("end");

        public static final Codec<Skybox> CODEC;
        private final String name;

        private Skybox(String name) {
            this.name = name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Skybox::values);
        }
    }

    public static enum CardinalLightType implements StringRepresentable
    {
        DEFAULT("default"),
        NETHER("nether");

        public static final Codec<CardinalLightType> CODEC;
        private final String name;

        private CardinalLightType(String name) {
            this.name = name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(CardinalLightType::values);
        }
    }
}

