/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.serialization.MapCodec;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

@Deprecated
public class CountOnEveryLayerPlacement
extends PlacementModifier {
    public static final MapCodec<CountOnEveryLayerPlacement> CODEC = IntProvider.codec(0, 256).fieldOf("count").xmap(CountOnEveryLayerPlacement::new, placement -> placement.count);
    private final IntProvider count;

    private CountOnEveryLayerPlacement(IntProvider count) {
        this.count = count;
    }

    public static CountOnEveryLayerPlacement of(IntProvider count) {
        return new CountOnEveryLayerPlacement(count);
    }

    public static CountOnEveryLayerPlacement of(int count) {
        return CountOnEveryLayerPlacement.of(ConstantInt.of(count));
    }

    @Override
    public Stream<BlockPos> getPositions(PlacementContext context, RandomSource random, BlockPos pos) {
        boolean flag;
        Stream.Builder<BlockPos> builder = Stream.builder();
        int i = 0;
        do {
            flag = false;
            for (int i1 = 0; i1 < this.count.sample(random); ++i1) {
                int i3;
                int height;
                int i2 = random.nextInt(16) + pos.getX();
                int i4 = CountOnEveryLayerPlacement.findOnGroundYPosition(context, i2, height = context.getHeight(Heightmap.Types.MOTION_BLOCKING, i2, i3 = random.nextInt(16) + pos.getZ()), i3, i);
                if (i4 == Integer.MAX_VALUE) continue;
                builder.add(new BlockPos(i2, i4, i3));
                flag = true;
            }
            ++i;
        } while (flag);
        return builder.build();
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.COUNT_ON_EVERY_LAYER;
    }

    private static int findOnGroundYPosition(PlacementContext context, int x, int y, int z, int count) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        int i = 0;
        BlockState blockState = context.getBlockState(mutableBlockPos);
        for (int i1 = y; i1 >= context.getMinY() + 1; --i1) {
            mutableBlockPos.setY(i1 - 1);
            BlockState blockState1 = context.getBlockState(mutableBlockPos);
            if (!CountOnEveryLayerPlacement.isEmpty(blockState1) && CountOnEveryLayerPlacement.isEmpty(blockState) && !blockState1.is(Blocks.BEDROCK)) {
                if (i == count) {
                    return mutableBlockPos.getY() + 1;
                }
                ++i;
            }
            blockState = blockState1;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isEmpty(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) || state.is(Blocks.LAVA);
    }
}

