/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RuinedPortalStructure
extends Structure {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float PROBABILITY_OF_GIANT_PORTAL = 0.05f;
    private static final int MIN_Y_INDEX = 15;
    private final List<Setup> setups;
    public static final MapCodec<RuinedPortalStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(RuinedPortalStructure.settingsCodec(instance), (App)ExtraCodecs.nonEmptyList(Setup.CODEC.listOf()).fieldOf("setups").forGetter(structure -> structure.setups)).apply((Applicative)instance, RuinedPortalStructure::new));

    public RuinedPortalStructure(Structure.StructureSettings settings, List<Setup> setups) {
        super(settings);
        this.setups = setups;
    }

    public RuinedPortalStructure(Structure.StructureSettings settings, Setup setup) {
        this(settings, List.of(setup));
    }

    @Override
    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        RuinedPortalPiece.Properties properties = new RuinedPortalPiece.Properties();
        WorldgenRandom worldgenRandom = context.random();
        Setup setup = null;
        if (this.setups.size() > 1) {
            float f = 0.0f;
            for (Setup setup2 : this.setups) {
                f += setup2.weight();
            }
            float randomFloat = worldgenRandom.nextFloat();
            for (Setup setup2 : this.setups) {
                if (!((randomFloat -= setup2.weight() / f) < 0.0f)) continue;
                setup = setup2;
                break;
            }
        } else {
            setup = this.setups.get(0);
        }
        if (setup == null) {
            throw new IllegalStateException();
        }
        Setup setup3 = setup;
        properties.airPocket = RuinedPortalStructure.sample(worldgenRandom, setup3.airPocketProbability());
        properties.mossiness = setup3.mossiness();
        properties.overgrown = setup3.overgrown();
        properties.vines = setup3.vines();
        properties.replaceWithBlackstone = setup3.replaceWithBlackstone();
        Identifier identifier = worldgenRandom.nextFloat() < 0.05f ? Identifier.withDefaultNamespace(STRUCTURE_LOCATION_GIANT_PORTALS[worldgenRandom.nextInt(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : Identifier.withDefaultNamespace(STRUCTURE_LOCATION_PORTALS[worldgenRandom.nextInt(STRUCTURE_LOCATION_PORTALS.length)]);
        StructureTemplate structureTemplate = context.structureTemplateManager().getOrCreate(identifier);
        Rotation rotation = Util.getRandom(Rotation.values(), (RandomSource)worldgenRandom);
        Mirror mirror = worldgenRandom.nextFloat() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos blockPos = new BlockPos(structureTemplate.getSize().getX() / 2, 0, structureTemplate.getSize().getZ() / 2);
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        LevelHeightAccessor levelHeightAccessor = context.heightAccessor();
        RandomState randomState = context.randomState();
        BlockPos worldPosition = context.chunkPos().getWorldPosition();
        BoundingBox boundingBox = structureTemplate.getBoundingBox(worldPosition, rotation, blockPos, mirror);
        BlockPos center = boundingBox.getCenter();
        int i = chunkGenerator.getBaseHeight(center.getX(), center.getZ(), RuinedPortalPiece.getHeightMapType(setup3.placement()), levelHeightAccessor, randomState) - 1;
        int i1 = RuinedPortalStructure.findSuitableY(worldgenRandom, chunkGenerator, setup3.placement(), properties.airPocket, i, boundingBox.getYSpan(), boundingBox, levelHeightAccessor, randomState);
        BlockPos blockPos1 = new BlockPos(worldPosition.getX(), i1, worldPosition.getZ());
        return Optional.of(new Structure.GenerationStub(blockPos1, structurePiecesBuilder -> {
            if (setup3.canBeCold()) {
                properties.cold = RuinedPortalStructure.isCold(blockPos1, context.chunkGenerator().getBiomeSource().getNoiseBiome(QuartPos.fromBlock(blockPos1.getX()), QuartPos.fromBlock(blockPos1.getY()), QuartPos.fromBlock(blockPos1.getZ()), randomState.sampler()), chunkGenerator.getSeaLevel());
            }
            structurePiecesBuilder.addPiece(new RuinedPortalPiece(context.structureTemplateManager(), blockPos1, setup3.placement(), properties, identifier, structureTemplate, rotation, mirror, blockPos));
        }));
    }

    private static boolean sample(WorldgenRandom random, float threshold) {
        return threshold != 0.0f && (threshold == 1.0f || random.nextFloat() < threshold);
    }

    private static boolean isCold(BlockPos pos, Holder<Biome> biome, int seaLevel) {
        return biome.value().coldEnoughToSnow(pos, seaLevel);
    }

    private static int findSuitableY(RandomSource random, ChunkGenerator chunkGenerator, RuinedPortalPiece.VerticalPlacement verticalPlacement, boolean airPocket, int height, int blockCountY, BoundingBox box, LevelHeightAccessor level, RandomState randomState) {
        int i3;
        int i = level.getMinY() + 15;
        if (verticalPlacement == RuinedPortalPiece.VerticalPlacement.IN_NETHER) {
            i1 = airPocket ? Mth.randomBetweenInclusive(random, 32, 100) : (random.nextFloat() < 0.5f ? Mth.randomBetweenInclusive(random, 27, 29) : Mth.randomBetweenInclusive(random, 29, 100));
        } else if (verticalPlacement == RuinedPortalPiece.VerticalPlacement.IN_MOUNTAIN) {
            i2 = height - blockCountY;
            i1 = RuinedPortalStructure.getRandomWithinInterval(random, 70, i2);
        } else if (verticalPlacement == RuinedPortalPiece.VerticalPlacement.UNDERGROUND) {
            i2 = height - blockCountY;
            i1 = RuinedPortalStructure.getRandomWithinInterval(random, i, i2);
        } else {
            i1 = verticalPlacement == RuinedPortalPiece.VerticalPlacement.PARTLY_BURIED ? height - blockCountY + Mth.randomBetweenInclusive(random, 2, 8) : height;
        }
        ImmutableList list = ImmutableList.of((Object)new BlockPos(box.minX(), 0, box.minZ()), (Object)new BlockPos(box.maxX(), 0, box.minZ()), (Object)new BlockPos(box.minX(), 0, box.maxZ()), (Object)new BlockPos(box.maxX(), 0, box.maxZ()));
        List list1 = list.stream().map(pos -> chunkGenerator.getBaseColumn(pos.getX(), pos.getZ(), level, randomState)).collect(Collectors.toList());
        Heightmap.Types types = verticalPlacement == RuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE_WG;
        for (i3 = i1; i3 > i; --i3) {
            int i4 = 0;
            for (NoiseColumn noiseColumn : list1) {
                BlockState block = noiseColumn.getBlock(i3);
                if (!types.isOpaque().test(block) || ++i4 != 3) continue;
                return i3;
            }
        }
        return i3;
    }

    private static int getRandomWithinInterval(RandomSource random, int min, int max) {
        return min < max ? Mth.randomBetweenInclusive(random, min, max) : max;
    }

    @Override
    public StructureType<?> type() {
        return StructureType.RUINED_PORTAL;
    }

    public record Setup(RuinedPortalPiece.VerticalPlacement placement, float airPocketProbability, float mossiness, boolean overgrown, boolean vines, boolean canBeCold, boolean replaceWithBlackstone, float weight) {
        public static final Codec<Setup> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuinedPortalPiece.VerticalPlacement.CODEC.fieldOf("placement").forGetter(Setup::placement), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(Setup::airPocketProbability), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(Setup::mossiness), (App)Codec.BOOL.fieldOf("overgrown").forGetter(Setup::overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(Setup::vines), (App)Codec.BOOL.fieldOf("can_be_cold").forGetter(Setup::canBeCold), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(Setup::replaceWithBlackstone), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("weight").forGetter(Setup::weight)).apply((Applicative)instance, Setup::new));
    }
}

