/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import ca.spottedleaf.moonrise.patches.starlight.light.StarLightInterface;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightLightingProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;
import net.minecraft.world.level.lighting.LightEventListener;
import org.jspecify.annotations.Nullable;

public class LevelLightEngine
implements LightEventListener,
StarLightLightingProvider {
    public static final int LIGHT_SECTION_PADDING = 1;
    public static final LevelLightEngine EMPTY = new LevelLightEngine();
    protected final LevelHeightAccessor levelHeightAccessor;
    protected final StarLightInterface lightEngine;

    @Override
    public final StarLightInterface starlight$getLightEngine() {
        return this.lightEngine;
    }

    @Override
    public void starlight$clientUpdateLight(LightLayer lightType, SectionPos pos, DataLayer nibble, boolean trustEdges) {
        throw new IllegalStateException("This hook is for the CLIENT ONLY");
    }

    @Override
    public void starlight$clientRemoveLightData(ChunkPos chunkPos) {
        throw new IllegalStateException("This hook is for the CLIENT ONLY");
    }

    @Override
    public void starlight$clientChunkLoad(ChunkPos pos, LevelChunk chunk) {
        throw new IllegalStateException("This hook is for the CLIENT ONLY");
    }

    public LevelLightEngine(LightChunkGetter lightChunkGetter, boolean blockLight, boolean skyLight) {
        this.levelHeightAccessor = lightChunkGetter.getLevel();
        this.lightEngine = lightChunkGetter.getLevel() instanceof Level ? new StarLightInterface(lightChunkGetter, skyLight, blockLight, this) : new StarLightInterface(null, skyLight, blockLight, this);
    }

    private LevelLightEngine() {
        this.levelHeightAccessor = LevelHeightAccessor.create(0, 0);
        this.lightEngine = new StarLightInterface(null, false, false, this);
    }

    @Override
    public void checkBlock(BlockPos pos) {
        this.lightEngine.blockChange(pos.immutable());
    }

    @Override
    public boolean hasLightWork() {
        return this.lightEngine.hasUpdates();
    }

    @Override
    public int runLightUpdates() {
        boolean hadUpdates = this.hasLightWork();
        this.lightEngine.propagateChanges();
        return hadUpdates ? 1 : 0;
    }

    @Override
    public void updateSectionStatus(SectionPos pos, boolean isEmpty) {
        this.lightEngine.sectionChange(pos, isEmpty);
    }

    @Override
    public void setLightEnabled(ChunkPos chunkPos, boolean lightEnabled) {
    }

    @Override
    public void propagateLightSources(ChunkPos chunkPos) {
    }

    public LayerLightEventListener getLayerListener(LightLayer lightLayer) {
        return lightLayer == LightLayer.BLOCK ? this.lightEngine.getBlockReader() : this.lightEngine.getSkyReader();
    }

    public String getDebugData(LightLayer lightLayer, SectionPos sectionPos) {
        return "n/a";
    }

    public LayerLightSectionStorage.SectionType getDebugSectionType(LightLayer lightLayer, SectionPos sectionPos) {
        throw new UnsupportedOperationException();
    }

    public void queueSectionData(LightLayer lightLayer, SectionPos sectionPos, @Nullable DataLayer dataLayer) {
    }

    public void retainData(ChunkPos pos, boolean retain) {
    }

    public int getRawBrightness(BlockPos pos, int amount) {
        return this.lightEngine.getRawBrightness(pos, amount);
    }

    public boolean lightOnInColumn(long columnPos) {
        throw new UnsupportedOperationException();
    }

    public int getLightSectionCount() {
        return this.levelHeightAccessor.getSectionsCount() + 2;
    }

    public int getMinLightSection() {
        return this.levelHeightAccessor.getMinSectionY() - 1;
    }

    public int getMaxLightSection() {
        return this.getMinLightSection() + this.getLightSectionCount();
    }
}

