/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.DataLayerStorageMap;
import net.minecraft.world.level.lighting.LayerLightSectionStorage;

public class SkyLightSectionStorage
extends LayerLightSectionStorage<SkyDataLayerStorageMap> {
    protected SkyLightSectionStorage(LightChunkGetter chunkSource) {
        super(LightLayer.SKY, chunkSource, new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)new Long2ObjectOpenHashMap(), new Long2IntOpenHashMap(), Integer.MAX_VALUE));
    }

    @Override
    protected int getLightValue(long pos) {
        return this.getLightValue(pos, false);
    }

    protected int getLightValue(long packedPos, boolean updateAll) {
        long packedSectionPos = SectionPos.blockToSection(packedPos);
        int sectionY = SectionPos.y(packedSectionPos);
        SkyDataLayerStorageMap skyDataLayerStorageMap = updateAll ? (SkyDataLayerStorageMap)this.updatingSectionData : (SkyDataLayerStorageMap)this.visibleSectionData;
        int i = skyDataLayerStorageMap.topSections.get(SectionPos.getZeroNode(packedSectionPos));
        if (i != skyDataLayerStorageMap.currentLowestY && sectionY < i) {
            DataLayer dataLayer = this.getDataLayer(skyDataLayerStorageMap, packedSectionPos);
            if (dataLayer == null) {
                packedPos = BlockPos.getFlatIndex(packedPos);
                while (dataLayer == null) {
                    if (++sectionY >= i) {
                        return 15;
                    }
                    packedSectionPos = SectionPos.offset(packedSectionPos, Direction.UP);
                    dataLayer = this.getDataLayer(skyDataLayerStorageMap, packedSectionPos);
                }
            }
            return dataLayer.get(SectionPos.sectionRelative(BlockPos.getX(packedPos)), SectionPos.sectionRelative(BlockPos.getY(packedPos)), SectionPos.sectionRelative(BlockPos.getZ(packedPos)));
        }
        return updateAll && !this.lightOnInSection(packedSectionPos) ? 0 : 15;
    }

    @Override
    protected void onNodeAdded(long sectionPos) {
        long zeroNode;
        int i;
        int sectionY = SectionPos.y(sectionPos);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY > sectionY) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY = sectionY;
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.defaultReturnValue(((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY);
        }
        if ((i = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(zeroNode = SectionPos.getZeroNode(sectionPos))) < sectionY + 1) {
            ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(zeroNode, sectionY + 1);
        }
    }

    @Override
    protected void onNodeRemoved(long sectionPos) {
        long zeroNode = SectionPos.getZeroNode(sectionPos);
        int sectionY = SectionPos.y(sectionPos);
        if (((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(zeroNode) == sectionY + 1) {
            long l = sectionPos;
            while (!this.storingLightForSection(l) && this.hasLightDataAtOrBelow(sectionY)) {
                --sectionY;
                l = SectionPos.offset(l, Direction.DOWN);
            }
            if (this.storingLightForSection(l)) {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.put(zeroNode, sectionY + 1);
            } else {
                ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.remove(zeroNode);
            }
        }
    }

    @Override
    protected DataLayer createDataLayer(long sectionPos) {
        DataLayer dataLayer = (DataLayer)this.queuedSections.get(sectionPos);
        if (dataLayer != null) {
            return dataLayer;
        }
        int i = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(SectionPos.getZeroNode(sectionPos));
        if (i != ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY && SectionPos.y(sectionPos) < i) {
            DataLayer dataLayer1;
            long l = SectionPos.offset(sectionPos, Direction.UP);
            while ((dataLayer1 = this.getDataLayer(l, true)) == null) {
                l = SectionPos.offset(l, Direction.UP);
            }
            return SkyLightSectionStorage.repeatFirstLayer(dataLayer1);
        }
        return this.lightOnInSection(sectionPos) ? new DataLayer(15) : new DataLayer();
    }

    private static DataLayer repeatFirstLayer(DataLayer dataLayer) {
        if (dataLayer.isDefinitelyHomogenous()) {
            return dataLayer.copy();
        }
        byte[] data = dataLayer.getData();
        byte[] bytes = new byte[2048];
        for (int i = 0; i < 16; ++i) {
            System.arraycopy(data, 0, bytes, i * 128, 128);
        }
        return new DataLayer(bytes);
    }

    protected boolean hasLightDataAtOrBelow(int y) {
        return y >= ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected boolean isAboveData(long sectionPos) {
        long zeroNode = SectionPos.getZeroNode(sectionPos);
        int i = ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(zeroNode);
        return i == ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY || SectionPos.y(sectionPos) >= i;
    }

    protected int getTopSectionY(long sectionPos) {
        return ((SkyDataLayerStorageMap)this.updatingSectionData).topSections.get(sectionPos);
    }

    protected int getBottomSectionY() {
        return ((SkyDataLayerStorageMap)this.updatingSectionData).currentLowestY;
    }

    protected static final class SkyDataLayerStorageMap
    extends DataLayerStorageMap<SkyDataLayerStorageMap> {
        int currentLowestY;
        final Long2IntOpenHashMap topSections;

        public SkyDataLayerStorageMap(Long2ObjectOpenHashMap<DataLayer> map, Long2IntOpenHashMap topSections, int currentLowestY) {
            super(map);
            this.topSections = topSections;
            topSections.defaultReturnValue(currentLowestY);
            this.currentLowestY = currentLowestY;
        }

        @Override
        public SkyDataLayerStorageMap copy() {
            return new SkyDataLayerStorageMap((Long2ObjectOpenHashMap<DataLayer>)this.map.clone(), this.topSections.clone(), this.currentLowestY);
        }
    }
}

