/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.redstone.RedstoneWireEvaluator;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class DefaultRedstoneWireEvaluator
extends RedstoneWireEvaluator {
    public DefaultRedstoneWireEvaluator(RedStoneWireBlock wireBlock) {
        super(wireBlock);
    }

    @Override
    public void updatePowerStrength(Level level, BlockPos pos, BlockState state, @Nullable Orientation orientation, boolean updateShape) {
        int i = this.calculateTargetStrength(level, pos);
        int oldPower = state.getValue(RedStoneWireBlock.POWER);
        if (oldPower != i) {
            BlockRedstoneEvent event = new BlockRedstoneEvent((Block)CraftBlock.at(level, pos), oldPower, i);
            level.getCraftServer().getPluginManager().callEvent((Event)event);
            i = event.getNewCurrent();
        }
        if (oldPower != i) {
            if (level.getBlockState(pos) == state) {
                level.setBlock(pos, (BlockState)state.setValue(RedStoneWireBlock.POWER, i), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction direction : Direction.values()) {
                set.add(pos.relative(direction));
            }
            for (BlockPos blockPos : set) {
                level.updateNeighborsAt(blockPos, this.wireBlock);
            }
        }
    }

    public int calculateTargetStrength(Level level, BlockPos pos) {
        int blockSignal = this.getBlockSignal(level, pos);
        return blockSignal == 15 ? blockSignal : Math.max(blockSignal, this.getIncomingWireSignal(level, pos));
    }
}

