/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jspecify.annotations.Nullable;

public interface LootContextArg<R> {
    public static final Codec<LootContextArg<Object>> ENTITY_OR_BLOCK = LootContextArg.createArgCodec(argCodecBuilder -> argCodecBuilder.anyOf(LootContext.EntityTarget.values()).anyOf(LootContext.BlockEntityTarget.values()));

    public @Nullable R get(LootContext var1);

    public ContextKey<?> contextParam();

    public static <U> LootContextArg<U> cast(LootContextArg<? extends U> arg) {
        return arg;
    }

    public static <R> Codec<LootContextArg<R>> createArgCodec(UnaryOperator<ArgCodecBuilder<R>> builder) {
        return ((ArgCodecBuilder)builder.apply(new ArgCodecBuilder())).build();
    }

    public static final class ArgCodecBuilder<R> {
        private final ExtraCodecs.LateBoundIdMapper<String, LootContextArg<R>> sources = new ExtraCodecs.LateBoundIdMapper();

        ArgCodecBuilder() {
        }

        public <T> ArgCodecBuilder<R> anyOf(T[] values, Function<T, String> nameGetter, Function<T, ? extends LootContextArg<R>> factory) {
            for (T object : values) {
                this.sources.put(nameGetter.apply(object), factory.apply(object));
            }
            return this;
        }

        public <T extends StringRepresentable> ArgCodecBuilder<R> anyOf(T[] values, Function<T, ? extends LootContextArg<R>> factory) {
            return this.anyOf(values, StringRepresentable::getSerializedName, factory);
        }

        public <T extends StringRepresentable & LootContextArg<? extends R>> ArgCodecBuilder<R> anyOf(T[] values) {
            return this.anyOf((StringRepresentable[])values, object -> LootContextArg.cast((LootContextArg)((Object)object)));
        }

        public ArgCodecBuilder<R> anyEntity(Function<? super ContextKey<? extends Entity>, ? extends LootContextArg<R>> factory) {
            return this.anyOf(LootContext.EntityTarget.values(), entityTarget -> (LootContextArg)factory.apply(entityTarget.contextParam()));
        }

        public ArgCodecBuilder<R> anyBlockEntity(Function<? super ContextKey<? extends BlockEntity>, ? extends LootContextArg<R>> factory) {
            return this.anyOf(LootContext.BlockEntityTarget.values(), blockEntityTarget -> (LootContextArg)factory.apply(blockEntityTarget.contextParam()));
        }

        public ArgCodecBuilder<R> anyItemStack(Function<? super ContextKey<? extends ItemStack>, ? extends LootContextArg<R>> factory) {
            return this.anyOf(LootContext.ItemStackTarget.values(), itemStackTarget -> (LootContextArg)factory.apply(itemStackTarget.contextParam()));
        }

        Codec<LootContextArg<R>> build() {
            return this.sources.codec((Codec<String>)Codec.STRING);
        }
    }

    public static interface SimpleGetter<T>
    extends LootContextArg<T> {
        @Override
        public ContextKey<? extends T> contextParam();

        @Override
        default public @Nullable T get(LootContext context) {
            return context.getOptionalParameter(this.contextParam());
        }
    }

    public static interface Getter<T, R>
    extends LootContextArg<R> {
        public @Nullable R get(T var1);

        @Override
        public ContextKey<? extends T> contextParam();

        @Override
        default public @Nullable R get(LootContext context) {
            T optionalParameter = context.getOptionalParameter(this.contextParam());
            return optionalParameter != null ? (R)this.get(optionalParameter) : null;
        }
    }
}

