/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.math.IntMath;
import com.mojang.math.OctahedralGroup;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.CubeVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteCubeMerger;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.IdenticalMerger;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.IndirectMerger;
import net.minecraft.world.phys.shapes.NonOverlappingMerger;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Shapes {
    public static final double EPSILON = 1.0E-7;
    public static final double BIG_EPSILON = 1.0E-6;
    private static final VoxelShape BLOCK = Util.make(() -> {
        BitSetDiscreteVoxelShape shape = new BitSetDiscreteVoxelShape(1, 1, 1);
        ((DiscreteVoxelShape)shape).fill(0, 0, 0);
        return new ArrayVoxelShape((DiscreteVoxelShape)shape, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE, (DoubleList)CollisionUtil.ZERO_ONE);
    });
    private static final Vec3 BLOCK_CENTER = new Vec3(0.5, 0.5, 0.5);
    public static final VoxelShape INFINITY = Shapes.box(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape EMPTY = new ArrayVoxelShape((DiscreteVoxelShape)new BitSetDiscreteVoxelShape(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));
    private static final DoubleArrayList[] PARTS_BY_BITS = new DoubleArrayList[]{DoubleArrayList.wrap((double[])Shapes.generateCubeParts(1)), DoubleArrayList.wrap((double[])Shapes.generateCubeParts(2)), DoubleArrayList.wrap((double[])Shapes.generateCubeParts(4)), DoubleArrayList.wrap((double[])Shapes.generateCubeParts(8))};

    public static VoxelShape empty() {
        return EMPTY;
    }

    public static VoxelShape block() {
        return BLOCK;
    }

    private static double[] generateCubeParts(int parts) {
        double inc = 1.0 / (double)parts;
        double[] ret = new double[parts + 1];
        double val = 0.0;
        for (int i = 0; i <= parts; ++i) {
            ret[i] = val;
            val += inc;
        }
        return ret;
    }

    public static VoxelShape box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(minX > maxX || minY > maxY || minZ > maxZ)) {
            return Shapes.create(minX, minY, minZ, maxX, maxY, maxZ);
        }
        throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
    }

    public static VoxelShape create(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(maxX - minX < 1.0E-7 || maxY - minY < 1.0E-7 || maxZ - minZ < 1.0E-7)) {
            int bitsX = Shapes.findBits(minX, maxX);
            int bitsY = Shapes.findBits(minY, maxY);
            int bitsZ = Shapes.findBits(minZ, maxZ);
            if (bitsX >= 0 && bitsY >= 0 && bitsZ >= 0) {
                if (bitsX == 0 && bitsY == 0 && bitsZ == 0) {
                    return BLOCK;
                }
                int sizeX = 1 << bitsX;
                int sizeY = 1 << bitsY;
                int sizeZ = 1 << bitsZ;
                BitSetDiscreteVoxelShape shape = BitSetDiscreteVoxelShape.withFilledBounds(sizeX, sizeY, sizeZ, (int)Math.round(minX * (double)sizeX), (int)Math.round(minY * (double)sizeY), (int)Math.round(minZ * (double)sizeZ), (int)Math.round(maxX * (double)sizeX), (int)Math.round(maxY * (double)sizeY), (int)Math.round(maxZ * (double)sizeZ));
                return new ArrayVoxelShape((DiscreteVoxelShape)shape, (DoubleList)PARTS_BY_BITS[bitsX], (DoubleList)PARTS_BY_BITS[bitsY], (DoubleList)PARTS_BY_BITS[bitsZ]);
            }
            return new ArrayVoxelShape(Shapes.BLOCK.shape, (DoubleList)(minX == 0.0 && maxX == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minX, maxX})), (DoubleList)(minY == 0.0 && maxY == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minY, maxY})), (DoubleList)(minZ == 0.0 && maxZ == 1.0 ? CollisionUtil.ZERO_ONE : DoubleArrayList.wrap((double[])new double[]{minZ, maxZ})));
        }
        return EMPTY;
    }

    public static VoxelShape create(AABB aabb) {
        return Shapes.create(aabb.minX, aabb.minY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ);
    }

    @VisibleForTesting
    protected static int findBits(double minBits, double maxBits) {
        if (!(minBits < -1.0E-7) && !(maxBits > 1.0000001)) {
            for (int i = 0; i <= 3; ++i) {
                boolean flag1;
                int i1 = 1 << i;
                double d = minBits * (double)i1;
                double d1 = maxBits * (double)i1;
                boolean flag = Math.abs(d - (double)Math.round(d)) < 1.0E-7 * (double)i1;
                boolean bl = flag1 = Math.abs(d1 - (double)Math.round(d1)) < 1.0E-7 * (double)i1;
                if (!flag || !flag1) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    protected static long lcm(int aa, int bb) {
        return (long)aa * (long)(bb / IntMath.gcd((int)aa, (int)bb));
    }

    public static VoxelShape or(VoxelShape shape1, VoxelShape shape2) {
        return Shapes.join(shape1, shape2, BooleanOp.OR);
    }

    public static VoxelShape or(VoxelShape shape1, VoxelShape ... others) {
        int size = others.length;
        if (size == 0) {
            return shape1;
        }
        VoxelShape[] tmp = Arrays.copyOf(others, ++size);
        tmp[size - 1] = shape1;
        while (size > 1) {
            int newSize = 0;
            for (int i = 0; i < size; i += 2) {
                int next = i + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i];
                    break;
                }
                VoxelShape first = tmp[i];
                VoxelShape second = tmp[next];
                tmp[newSize++] = Shapes.joinUnoptimized(first, second, BooleanOp.OR);
            }
            size = newSize;
        }
        return tmp[0].optimize();
    }

    public static VoxelShape join(VoxelShape shape1, VoxelShape shape2, BooleanOp function) {
        return CollisionUtil.joinOptimized(shape1, shape2, function);
    }

    public static VoxelShape joinUnoptimized(VoxelShape shape1, VoxelShape shape2, BooleanOp function) {
        return CollisionUtil.joinUnoptimized(shape1, shape2, function);
    }

    public static boolean joinIsNotEmpty(VoxelShape shape1, VoxelShape shape2, BooleanOp resultOperator) {
        return CollisionUtil.isJoinNonEmpty(shape1, shape2, resultOperator);
    }

    private static boolean joinIsNotEmpty(IndexMerger mergerX, IndexMerger mergerY, IndexMerger mergerZ, DiscreteVoxelShape primaryShape, DiscreteVoxelShape secondaryShape, BooleanOp resultOperator) {
        return !mergerX.forMergedIndexes((x1, y1, z1) -> mergerY.forMergedIndexes((x2, y2, z2) -> mergerZ.forMergedIndexes((x3, y3, z3) -> !resultOperator.apply(primaryShape.isFullWide(x1, x2, x3), secondaryShape.isFullWide(y1, y2, y3)))));
    }

    public static double collide(Direction.Axis movementAxis, AABB collisionBox, Iterable<VoxelShape> possibleHits, double desiredOffset) {
        for (VoxelShape voxelShape : possibleHits) {
            if (Math.abs(desiredOffset) < 1.0E-7) {
                return 0.0;
            }
            desiredOffset = voxelShape.collide(movementAxis, collisionBox, desiredOffset);
        }
        return desiredOffset;
    }

    public static boolean blockOccludes(VoxelShape first, VoxelShape second, Direction direction) {
        if (first == BLOCK & second == BLOCK) {
            return true;
        }
        if (first.isEmpty() | second.isEmpty()) {
            return false;
        }
        VoxelShape newFirst = first.moonrise$getFaceShapeClamped(direction);
        if (newFirst.isEmpty()) {
            return false;
        }
        VoxelShape newSecond = second.moonrise$getFaceShapeClamped(direction.getOpposite());
        if (newSecond.isEmpty()) {
            return false;
        }
        return !Shapes.joinIsNotEmpty(newFirst, newSecond, BooleanOp.ONLY_FIRST);
    }

    private static boolean mergedMayOccludeBlock(VoxelShape shape1, VoxelShape shape2) {
        AABB bounds1 = shape1.bounds();
        AABB bounds2 = shape2.bounds();
        double minX = Math.min(bounds1.minX, bounds2.minX);
        double minY = Math.min(bounds1.minY, bounds2.minY);
        double minZ = Math.min(bounds1.minZ, bounds2.minZ);
        double maxX = Math.max(bounds1.maxX, bounds2.maxX);
        double maxY = Math.max(bounds1.maxY, bounds2.maxY);
        double maxZ = Math.max(bounds1.maxZ, bounds2.maxZ);
        return minX <= 1.0E-7 && maxX >= 0.9999999 && minY <= 1.0E-7 && maxY >= 0.9999999 && minZ <= 1.0E-7 && maxZ >= 0.9999999;
    }

    public static boolean mergedFaceOccludes(VoxelShape first, VoxelShape second, Direction direction) {
        boolean secondEmpty;
        if (first.moonrise$occludesFullBlockIfCached() || second.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        if (first.isEmpty() & second.isEmpty()) {
            return false;
        }
        VoxelShape newFirst = first.moonrise$getFaceShapeClamped(direction);
        VoxelShape newSecond = second.moonrise$getFaceShapeClamped(direction.getOpposite());
        if (newFirst.moonrise$occludesFullBlockIfCached() || newSecond.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean firstEmpty = newFirst.isEmpty();
        if (firstEmpty & (secondEmpty = newSecond.isEmpty())) {
            return false;
        }
        if (firstEmpty | secondEmpty) {
            return secondEmpty ? newFirst.moonrise$occludesFullBlock() : newSecond.moonrise$occludesFullBlock();
        }
        if (newFirst == newSecond) {
            return newFirst.moonrise$occludesFullBlock();
        }
        return Shapes.mergedMayOccludeBlock(newFirst, newSecond) && newFirst.moonrise$orUnoptimized(newSecond).moonrise$occludesFullBlock();
    }

    public static boolean faceShapeOccludes(VoxelShape shape1, VoxelShape shape2) {
        boolean s2Empty;
        if (shape1.moonrise$occludesFullBlockIfCached() || shape2.moonrise$occludesFullBlockIfCached()) {
            return true;
        }
        boolean s1Empty = shape1.isEmpty();
        if (s1Empty & (s2Empty = shape2.isEmpty())) {
            return false;
        }
        if (s1Empty | s2Empty) {
            return s2Empty ? shape1.moonrise$occludesFullBlock() : shape2.moonrise$occludesFullBlock();
        }
        if (shape1 == shape2) {
            return shape1.moonrise$occludesFullBlock();
        }
        return Shapes.mergedMayOccludeBlock(shape1, shape2) && shape1.moonrise$orUnoptimized(shape2).moonrise$occludesFullBlock();
    }

    @VisibleForTesting
    private static IndexMerger createIndexMerger(int size, DoubleList list1, DoubleList list2, boolean excludeUpper, boolean excludeLower) {
        if (list1.getDouble(0) == Double.NEGATIVE_INFINITY && list1.getDouble(list1.size() - 1) == Double.POSITIVE_INFINITY) {
            return new IndirectMerger(list1, list2, excludeUpper, excludeLower);
        }
        return Shapes.lessCommonMerge(size, list1, list2, excludeUpper, excludeLower);
    }

    private static IndexMerger lessCommonMerge(int size, DoubleList list1, DoubleList list2, boolean excludeUpper, boolean excludeLower) {
        long l;
        int i = list1.size() - 1;
        int i1 = list2.size() - 1;
        if (list1 instanceof CubePointRange && list2 instanceof CubePointRange && (long)size * (l = Shapes.lcm(i, i1)) <= 256L) {
            return new DiscreteCubeMerger(i, i1);
        }
        if (i == i1 && Objects.equals(list1, list2)) {
            if (list1 instanceof IdenticalMerger) {
                return (IndexMerger)list1;
            }
            if (list2 instanceof IdenticalMerger) {
                return (IndexMerger)list2;
            }
            return new IdenticalMerger(list1);
        }
        if (list1.getDouble(i) < list2.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(list1, list2, false);
        }
        if (list2.getDouble(i1) < list1.getDouble(0) - 1.0E-7) {
            return new NonOverlappingMerger(list2, list1, true);
        }
        return new IndirectMerger(list1, list2, excludeUpper, excludeLower);
    }

    public static VoxelShape rotate(VoxelShape shape, OctahedralGroup rotation) {
        return Shapes.rotate(shape, rotation, BLOCK_CENTER);
    }

    public static VoxelShape rotate(VoxelShape shape, OctahedralGroup rotation, Vec3 rotationPoint) {
        if (rotation == OctahedralGroup.IDENTITY) {
            return shape;
        }
        DiscreteVoxelShape discreteVoxelShape = shape.shape.rotate(rotation);
        if (shape instanceof CubeVoxelShape && BLOCK_CENTER.equals(rotationPoint)) {
            return new CubeVoxelShape(discreteVoxelShape);
        }
        Direction.Axis axis = rotation.permutation().permuteAxis(Direction.Axis.X);
        Direction.Axis axis1 = rotation.permutation().permuteAxis(Direction.Axis.Y);
        Direction.Axis axis2 = rotation.permutation().permuteAxis(Direction.Axis.Z);
        DoubleList coords = shape.getCoords(axis);
        DoubleList coords1 = shape.getCoords(axis1);
        DoubleList coords2 = shape.getCoords(axis2);
        boolean flag = rotation.inverts(Direction.Axis.X);
        boolean flag1 = rotation.inverts(Direction.Axis.Y);
        boolean flag2 = rotation.inverts(Direction.Axis.Z);
        return new ArrayVoxelShape(discreteVoxelShape, Shapes.flipAxisIfNeeded(coords, flag, rotationPoint.get(axis), rotationPoint.x), Shapes.flipAxisIfNeeded(coords1, flag1, rotationPoint.get(axis1), rotationPoint.y), Shapes.flipAxisIfNeeded(coords2, flag2, rotationPoint.get(axis2), rotationPoint.z));
    }

    @VisibleForTesting
    static DoubleList flipAxisIfNeeded(DoubleList coords, boolean invert, double from, double to) {
        if (!invert && from == to) {
            return coords;
        }
        int size = coords.size();
        DoubleArrayList list = new DoubleArrayList(size);
        if (invert) {
            for (int i = size - 1; i >= 0; --i) {
                list.add(-(coords.getDouble(i) - from) + to);
            }
        } else {
            for (int i = 0; i >= 0 && i < size; ++i) {
                list.add(coords.getDouble(i) - from + to);
            }
        }
        return list;
    }

    public static boolean equal(VoxelShape first, VoxelShape second) {
        return !Shapes.joinIsNotEmpty(first, second, BooleanOp.NOT_SAME);
    }

    public static Map<Direction.Axis, VoxelShape> rotateHorizontalAxis(VoxelShape zAxis) {
        return Shapes.rotateHorizontalAxis(zAxis, BLOCK_CENTER);
    }

    public static Map<Direction.Axis, VoxelShape> rotateHorizontalAxis(VoxelShape zAxis, Vec3 rotationCenter) {
        return Maps.newEnumMap(Map.of(Direction.Axis.Z, zAxis, Direction.Axis.X, Shapes.rotate(zAxis, OctahedralGroup.BLOCK_ROT_Y_90, rotationCenter)));
    }

    public static Map<Direction.Axis, VoxelShape> rotateAllAxis(VoxelShape north) {
        return Shapes.rotateAllAxis(north, BLOCK_CENTER);
    }

    public static Map<Direction.Axis, VoxelShape> rotateAllAxis(VoxelShape north, Vec3 rotationCenter) {
        return Maps.newEnumMap(Map.of(Direction.Axis.Z, north, Direction.Axis.X, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_Y_90, rotationCenter), Direction.Axis.Y, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_X_90, rotationCenter)));
    }

    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape north) {
        return Shapes.rotateHorizontal(north, OctahedralGroup.IDENTITY, BLOCK_CENTER);
    }

    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape north, OctahedralGroup initial) {
        return Shapes.rotateHorizontal(north, initial, BLOCK_CENTER);
    }

    public static Map<Direction, VoxelShape> rotateHorizontal(VoxelShape north, OctahedralGroup initial, Vec3 rotationCenter) {
        return Maps.newEnumMap(Map.of(Direction.NORTH, Shapes.rotate(north, initial), Direction.EAST, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_Y_90.compose(initial), rotationCenter), Direction.SOUTH, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_Y_180.compose(initial), rotationCenter), Direction.WEST, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_Y_270.compose(initial), rotationCenter)));
    }

    public static Map<Direction, VoxelShape> rotateAll(VoxelShape north) {
        return Shapes.rotateAll(north, OctahedralGroup.IDENTITY, BLOCK_CENTER);
    }

    public static Map<Direction, VoxelShape> rotateAll(VoxelShape north, Vec3 rotationCenter) {
        return Shapes.rotateAll(north, OctahedralGroup.IDENTITY, rotationCenter);
    }

    public static Map<Direction, VoxelShape> rotateAll(VoxelShape north, OctahedralGroup initial, Vec3 rotationCenter) {
        return Maps.newEnumMap(Map.of(Direction.NORTH, Shapes.rotate(north, initial), Direction.EAST, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_Y_90.compose(initial), rotationCenter), Direction.SOUTH, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_Y_180.compose(initial), rotationCenter), Direction.WEST, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_Y_270.compose(initial), rotationCenter), Direction.UP, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_X_270.compose(initial), rotationCenter), Direction.DOWN, Shapes.rotate(north, OctahedralGroup.BLOCK_ROT_X_90.compose(initial), rotationCenter)));
    }

    public static Map<AttachFace, Map<Direction, VoxelShape>> rotateAttachFace(VoxelShape north) {
        return Shapes.rotateAttachFace(north, OctahedralGroup.IDENTITY);
    }

    public static Map<AttachFace, Map<Direction, VoxelShape>> rotateAttachFace(VoxelShape north, OctahedralGroup initial) {
        return Map.of(AttachFace.WALL, Shapes.rotateHorizontal(north, initial), AttachFace.FLOOR, Shapes.rotateHorizontal(north, OctahedralGroup.BLOCK_ROT_X_270.compose(initial)), AttachFace.CEILING, Shapes.rotateHorizontal(north, OctahedralGroup.BLOCK_ROT_Y_180.compose(OctahedralGroup.BLOCK_ROT_X_90).compose(initial)));
    }

    public static interface DoubleLineConsumer {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

