/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import ca.spottedleaf.moonrise.common.util.FlatBitsetUtil;
import ca.spottedleaf.moonrise.patches.collisions.CollisionUtil;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedShapeData;
import ca.spottedleaf.moonrise.patches.collisions.shape.CachedToAABBs;
import ca.spottedleaf.moonrise.patches.collisions.shape.CollisionVoxelShape;
import ca.spottedleaf.moonrise.patches.collisions.shape.MergedORCache;
import com.google.common.math.DoubleMath;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.AxisCycle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.ArrayVoxelShape;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import net.minecraft.world.phys.shapes.OffsetDoubleList;
import net.minecraft.world.phys.shapes.Shapes;
import org.jspecify.annotations.Nullable;

public abstract class VoxelShape
implements CollisionVoxelShape {
    public final DiscreteVoxelShape shape;
    private @Nullable VoxelShape @Nullable [] faces;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private AABB singleAABBRepresentation;
    private double[] rootCoordinatesX;
    private double[] rootCoordinatesY;
    private double[] rootCoordinatesZ;
    private CachedShapeData cachedShapeData;
    private boolean isEmpty;
    private CachedToAABBs cachedToAABBs;
    private AABB cachedBounds;
    private Boolean isFullBlock;
    private Boolean occludesFullBlock;
    private static final int MERGED_CACHE_SIZE = 16;
    private MergedORCache[] mergedORCache;
    private VoxelShape[] faceShapeClampedCache;

    @Override
    public final double moonrise$offsetX() {
        return this.offsetX;
    }

    @Override
    public final double moonrise$offsetY() {
        return this.offsetY;
    }

    @Override
    public final double moonrise$offsetZ() {
        return this.offsetZ;
    }

    @Override
    public final AABB moonrise$getSingleAABBRepresentation() {
        return this.singleAABBRepresentation;
    }

    @Override
    public final double[] moonrise$rootCoordinatesX() {
        return this.rootCoordinatesX;
    }

    @Override
    public final double[] moonrise$rootCoordinatesY() {
        return this.rootCoordinatesY;
    }

    @Override
    public final double[] moonrise$rootCoordinatesZ() {
        return this.rootCoordinatesZ;
    }

    private static double[] extractRawArray(DoubleList list) {
        if (list instanceof DoubleArrayList) {
            int expected;
            DoubleArrayList rawList = (DoubleArrayList)list;
            double[] raw = rawList.elements();
            if (raw.length == (expected = rawList.size())) {
                return raw;
            }
            return Arrays.copyOf(raw, expected);
        }
        return list.toDoubleArray();
    }

    @Override
    public final void moonrise$initCache() {
        OffsetDoubleList offsetDoubleList;
        this.cachedShapeData = this.shape.moonrise$getOrCreateCachedShapeData();
        this.isEmpty = this.cachedShapeData.isEmpty();
        DoubleList xList = this.getCoords(Direction.Axis.X);
        DoubleList yList = this.getCoords(Direction.Axis.Y);
        DoubleList zList = this.getCoords(Direction.Axis.Z);
        if (xList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)xList;
            this.offsetX = offsetDoubleList.offset;
            this.rootCoordinatesX = VoxelShape.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesX = VoxelShape.extractRawArray(xList);
        }
        if (yList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)yList;
            this.offsetY = offsetDoubleList.offset;
            this.rootCoordinatesY = VoxelShape.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesY = VoxelShape.extractRawArray(yList);
        }
        if (zList instanceof OffsetDoubleList) {
            offsetDoubleList = (OffsetDoubleList)zList;
            this.offsetZ = offsetDoubleList.offset;
            this.rootCoordinatesZ = VoxelShape.extractRawArray(offsetDoubleList.delegate);
        } else {
            this.rootCoordinatesZ = VoxelShape.extractRawArray(zList);
        }
        if (this.cachedShapeData.hasSingleAABB()) {
            this.cachedBounds = this.singleAABBRepresentation = new AABB(this.rootCoordinatesX[0] + this.offsetX, this.rootCoordinatesY[0] + this.offsetY, this.rootCoordinatesZ[0] + this.offsetZ, this.rootCoordinatesX[1] + this.offsetX, this.rootCoordinatesY[1] + this.offsetY, this.rootCoordinatesZ[1] + this.offsetZ);
        }
    }

    @Override
    public final CachedShapeData moonrise$getCachedVoxelData() {
        return this.cachedShapeData;
    }

    @Override
    public final VoxelShape moonrise$getFaceShapeClamped(Direction direction) {
        VoxelShape ret;
        if (this.isEmpty) {
            return this;
        }
        if (this == Shapes.block()) {
            return this;
        }
        VoxelShape[] cache = this.faceShapeClampedCache;
        if (cache != null && (ret = cache[direction.ordinal()]) != null) {
            return ret;
        }
        if (cache == null) {
            this.faceShapeClampedCache = cache = new VoxelShape[6];
        }
        Direction.Axis axis = direction.getAxis();
        VoxelShape ret2 = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? (DoubleMath.fuzzyEquals((double)this.max(axis), (double)1.0, (double)1.0E-7) ? CollisionUtil.sliceShape(this, axis, this.shape.getSize(axis) - 1) : Shapes.empty()) : (DoubleMath.fuzzyEquals((double)this.min(axis), (double)0.0, (double)1.0E-7) ? CollisionUtil.sliceShape(this, axis, 0) : Shapes.empty());
        cache[direction.ordinal()] = ret2;
        return ret2;
    }

    private boolean computeOccludesFullBlock() {
        if (this.isEmpty) {
            this.occludesFullBlock = Boolean.FALSE;
            return false;
        }
        if (this.moonrise$isFullBlock()) {
            this.occludesFullBlock = Boolean.TRUE;
            return true;
        }
        AABB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            boolean ret = singleAABB.minY <= 1.0E-7 && singleAABB.maxY >= 0.9999999 && singleAABB.minX <= 1.0E-7 && singleAABB.maxX >= 0.9999999 && singleAABB.minZ <= 1.0E-7 && singleAABB.maxZ >= 0.9999999;
            this.occludesFullBlock = ret;
            return ret;
        }
        boolean ret = !Shapes.joinIsNotEmpty(Shapes.block(), this, BooleanOp.ONLY_FIRST);
        this.occludesFullBlock = ret;
        return ret;
    }

    @Override
    public final boolean moonrise$occludesFullBlock() {
        Boolean ret = this.occludesFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeOccludesFullBlock();
    }

    @Override
    public final boolean moonrise$occludesFullBlockIfCached() {
        Boolean ret = this.occludesFullBlock;
        return ret != null ? ret : false;
    }

    private static int hash(VoxelShape key) {
        return HashCommon.mix((int)System.identityHashCode(key));
    }

    @Override
    public final VoxelShape moonrise$orUnoptimized(VoxelShape other) {
        MergedORCache otherCache;
        MergedORCache cached;
        if (this == other) {
            return other;
        }
        if (this.isEmpty) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        int thisCacheKey = VoxelShape.hash(other) & 0xF;
        MergedORCache mergedORCache = cached = this.mergedORCache == null ? null : this.mergedORCache[thisCacheKey];
        if (cached != null && cached.key() == other) {
            return cached.result();
        }
        int otherCacheKey = VoxelShape.hash(this) & 0xF;
        MergedORCache mergedORCache2 = otherCache = other.mergedORCache == null ? null : other.mergedORCache[otherCacheKey];
        if (otherCache != null && otherCache.key() == this) {
            return otherCache.result();
        }
        VoxelShape result = Shapes.joinUnoptimized(this, other, BooleanOp.OR);
        if (cached != null && otherCache == null) {
            if (other.mergedORCache == null) {
                other.mergedORCache = new MergedORCache[16];
            }
            other.mergedORCache[otherCacheKey] = new MergedORCache(this, result);
        } else {
            if (this.mergedORCache == null) {
                this.mergedORCache = new MergedORCache[16];
            }
            this.mergedORCache[thisCacheKey] = new MergedORCache(other, result);
        }
        return result;
    }

    private static DoubleList offsetList(double[] src, double by) {
        DoubleArrayList wrap = DoubleArrayList.wrap((double[])src);
        if (by == 0.0) {
            return wrap;
        }
        return new OffsetDoubleList((DoubleList)wrap, by);
    }

    private List<AABB> toAabbsUncached() {
        ArrayList<AABB> ret;
        if (this.singleAABBRepresentation != null) {
            ret = new ArrayList(1);
            ret.add(this.singleAABBRepresentation);
        } else {
            ret = new ArrayList<AABB>();
            double[] coordsX = this.rootCoordinatesX;
            double[] coordsY = this.rootCoordinatesY;
            double[] coordsZ = this.rootCoordinatesZ;
            double offX = this.offsetX;
            double offY = this.offsetY;
            double offZ = this.offsetZ;
            this.shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> ret.add(new AABB(coordsX[minX] + offX, coordsY[minY] + offY, coordsZ[minZ] + offZ, coordsX[maxX] + offX, coordsY[maxY] + offY, coordsZ[maxZ] + offZ)), true);
        }
        this.cachedToAABBs = new CachedToAABBs(ret, false, 0.0, 0.0, 0.0);
        return ret;
    }

    private boolean computeFullBlock() {
        Boolean ret;
        block10: {
            if (this.isEmpty) {
                ret = Boolean.FALSE;
            } else if (this == Shapes.block()) {
                ret = Boolean.TRUE;
            } else {
                AABB singleAABB = this.singleAABBRepresentation;
                if (singleAABB == null) {
                    CachedShapeData shapeData = this.cachedShapeData;
                    int sMinX = shapeData.minFullX();
                    int sMinY = shapeData.minFullY();
                    int sMinZ = shapeData.minFullZ();
                    int sMaxX = shapeData.maxFullX();
                    int sMaxY = shapeData.maxFullY();
                    int sMaxZ = shapeData.maxFullZ();
                    if (Math.abs(this.rootCoordinatesX[sMinX] + this.offsetX) <= 1.0E-7 && Math.abs(this.rootCoordinatesY[sMinY] + this.offsetY) <= 1.0E-7 && Math.abs(this.rootCoordinatesZ[sMinZ] + this.offsetZ) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesX[sMaxX] + this.offsetX)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesY[sMaxY] + this.offsetY)) <= 1.0E-7 && Math.abs(1.0 - (this.rootCoordinatesZ[sMaxZ] + this.offsetZ)) <= 1.0E-7) {
                        int sizeY = shapeData.sizeY();
                        int sizeZ = shapeData.sizeZ();
                        long[] bitset = shapeData.voxelSet();
                        ret = Boolean.TRUE;
                        for (int x = sMinX; x < sMaxX; ++x) {
                            for (int y = sMinY; y < sMaxY; ++y) {
                                int baseIndex = y * sizeZ + x * (sizeZ * sizeY);
                                if (FlatBitsetUtil.isRangeSet(bitset, baseIndex + sMinZ, baseIndex + sMaxZ)) continue;
                                ret = Boolean.FALSE;
                                break block10;
                            }
                        }
                    } else {
                        ret = Boolean.FALSE;
                    }
                } else {
                    ret = Math.abs(singleAABB.minX) <= 1.0E-7 && Math.abs(singleAABB.minY) <= 1.0E-7 && Math.abs(singleAABB.minZ) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxX) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxY) <= 1.0E-7 && Math.abs(1.0 - singleAABB.maxZ) <= 1.0E-7;
                }
            }
        }
        this.isFullBlock = ret;
        return ret;
    }

    @Override
    public final boolean moonrise$isFullBlock() {
        Boolean ret = this.isFullBlock;
        if (ret != null) {
            return ret;
        }
        return this.computeFullBlock();
    }

    private static BlockHitResult clip(AABB aabb, Vec3 from, Vec3 to, BlockPos offset) {
        double[] minDistanceArr = new double[]{1.0};
        double diffX = to.x - from.x;
        double diffY = to.y - from.y;
        double diffZ = to.z - from.z;
        Direction direction = AABB.getDirection(aabb.move(offset), from, minDistanceArr, null, diffX, diffY, diffZ);
        if (direction == null) {
            return null;
        }
        double minDistance = minDistanceArr[0];
        return new BlockHitResult(from.add(minDistance * diffX, minDistance * diffY, minDistance * diffZ), direction, offset, false);
    }

    private VoxelShape calculateFaceDirect(Direction direction, Direction.Axis axis, double[] coords, double offset) {
        if (coords.length == 2 && DoubleMath.fuzzyEquals((double)(coords[0] + offset), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)(coords[1] + offset), (double)1.0, (double)1.0E-7)) {
            return this;
        }
        boolean positiveDir = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        int index = CollisionUtil.findFloor(coords, offset, positiveDir ? 0.9999999 : 1.0E-7, 0, coords.length - 1);
        return CollisionUtil.sliceShape(this, axis, index);
    }

    protected VoxelShape(DiscreteVoxelShape shape) {
        this.shape = shape;
    }

    public double min(Direction.Axis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case X: {
                int idx = shapeData.minFullX();
                return idx >= shapeData.sizeX() ? Double.POSITIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case Y: {
                int idx = shapeData.minFullY();
                return idx >= shapeData.sizeY() ? Double.POSITIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case Z: {
                int idx = shapeData.minFullZ();
                return idx >= shapeData.sizeZ() ? Double.POSITIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public double max(Direction.Axis axis) {
        CachedShapeData shapeData = this.cachedShapeData;
        switch (axis) {
            case X: {
                int idx = shapeData.maxFullX();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesX[idx] + this.offsetX;
            }
            case Y: {
                int idx = shapeData.maxFullY();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesY[idx] + this.offsetY;
            }
            case Z: {
                int idx = shapeData.maxFullZ();
                return idx <= 0 ? Double.NEGATIVE_INFINITY : this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public AABB bounds() {
        if (this.isEmpty) {
            throw Util.pauseInIde(new UnsupportedOperationException("No bounds for empty shape."));
        }
        AABB cached = this.cachedBounds;
        if (cached != null) {
            return cached;
        }
        CachedShapeData shapeData = this.cachedShapeData;
        double[] coordsX = this.rootCoordinatesX;
        double[] coordsY = this.rootCoordinatesY;
        double[] coordsZ = this.rootCoordinatesZ;
        double offX = this.offsetX;
        double offY = this.offsetY;
        double offZ = this.offsetZ;
        this.cachedBounds = cached = new AABB(coordsX[shapeData.minFullX()] + offX, coordsY[shapeData.minFullY()] + offY, coordsZ[shapeData.minFullZ()] + offZ, coordsX[shapeData.maxFullX()] + offX, coordsY[shapeData.maxFullY()] + offY, coordsZ[shapeData.maxFullZ()] + offZ);
        return cached;
    }

    public VoxelShape singleEncompassing() {
        if (this.isEmpty) {
            return Shapes.empty();
        }
        return Shapes.create(this.bounds());
    }

    protected double get(Direction.Axis axis, int index) {
        int idx = index;
        switch (axis) {
            case X: {
                return this.rootCoordinatesX[idx] + this.offsetX;
            }
            case Y: {
                return this.rootCoordinatesY[idx] + this.offsetY;
            }
            case Z: {
                return this.rootCoordinatesZ[idx] + this.offsetZ;
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    public abstract DoubleList getCoords(Direction.Axis var1);

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public VoxelShape move(Vec3 offset) {
        return this.move(offset.x, offset.y, offset.z);
    }

    public VoxelShape move(Vec3i offset) {
        return this.move(offset.getX(), offset.getY(), offset.getZ());
    }

    public VoxelShape move(double xOffset, double yOffset, double zOffset) {
        if (this.isEmpty) {
            return Shapes.empty();
        }
        ArrayVoxelShape ret = new ArrayVoxelShape(this.shape, VoxelShape.offsetList(this.rootCoordinatesX, this.offsetX + xOffset), VoxelShape.offsetList(this.rootCoordinatesY, this.offsetY + yOffset), VoxelShape.offsetList(this.rootCoordinatesZ, this.offsetZ + zOffset));
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            ((VoxelShape)ret).cachedToAABBs = CachedToAABBs.offset(cachedToAABBs, xOffset, yOffset, zOffset);
        }
        return ret;
    }

    public VoxelShape optimize() {
        if (this.isEmpty) {
            return Shapes.empty();
        }
        if (this.singleAABBRepresentation != null) {
            return this.moonrise$isFullBlock() ? Shapes.block() : this;
        }
        List<AABB> aabbs = this.toAabbs();
        if (aabbs.isEmpty()) {
            return Shapes.empty();
        }
        if (aabbs.size() == 1) {
            AABB singleAABB = aabbs.get(0);
            VoxelShape ret = Shapes.create(singleAABB);
            if (ret.cachedToAABBs == null) {
                ret.cachedToAABBs = this.cachedToAABBs;
            }
            return ret;
        }
        VoxelShape[] tmp = new VoxelShape[aabbs.size()];
        int len = aabbs.size();
        for (int i = 0; i < len; ++i) {
            tmp[i] = Shapes.create(aabbs.get(i));
        }
        int size = aabbs.size();
        while (size > 1) {
            int newSize = 0;
            for (int i = 0; i < size; i += 2) {
                int next = i + 1;
                if (next >= size) {
                    tmp[newSize++] = tmp[i];
                    break;
                }
                VoxelShape first = tmp[i];
                VoxelShape second = tmp[next];
                tmp[newSize++] = Shapes.joinUnoptimized(first, second, BooleanOp.OR);
            }
            size = newSize;
        }
        VoxelShape ret = tmp[0];
        if (ret.cachedToAABBs == null) {
            ret.cachedToAABBs = this.cachedToAABBs;
        }
        return ret;
    }

    public void forAllEdges(Shapes.DoubleLineConsumer action) {
        this.shape.forAllEdges((x1, y1, z1, x2, y2, z2) -> action.consume(this.get(Direction.Axis.X, x1), this.get(Direction.Axis.Y, y1), this.get(Direction.Axis.Z, z1), this.get(Direction.Axis.X, x2), this.get(Direction.Axis.Y, y2), this.get(Direction.Axis.Z, z2)), true);
    }

    public void forAllBoxes(Shapes.DoubleLineConsumer action) {
        DoubleList coords = this.getCoords(Direction.Axis.X);
        DoubleList coords1 = this.getCoords(Direction.Axis.Y);
        DoubleList coords2 = this.getCoords(Direction.Axis.Z);
        this.shape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> action.consume(coords.getDouble(x1), coords1.getDouble(y1), coords2.getDouble(z1), coords.getDouble(x2), coords1.getDouble(y2), coords2.getDouble(z2)), true);
    }

    public List<AABB> toAabbs() {
        CachedToAABBs cachedToAABBs = this.cachedToAABBs;
        if (cachedToAABBs != null) {
            if (!cachedToAABBs.isOffset()) {
                return cachedToAABBs.aabbs();
            }
            this.cachedToAABBs = cachedToAABBs = cachedToAABBs.removeOffset();
            return cachedToAABBs.aabbs();
        }
        return this.toAabbsUncached();
    }

    public double min(Direction.Axis axis, double primaryPosition, double secondaryPosition) {
        int i1;
        Direction.Axis axis1 = AxisCycle.FORWARD.cycle(axis);
        Direction.Axis axis2 = AxisCycle.BACKWARD.cycle(axis);
        int i = this.findIndex(axis1, primaryPosition);
        int i2 = this.shape.firstFull(axis, i, i1 = this.findIndex(axis2, secondaryPosition));
        return i2 >= this.shape.getSize(axis) ? Double.POSITIVE_INFINITY : this.get(axis, i2);
    }

    public double max(Direction.Axis axis, double primaryPosition, double secondaryPosition) {
        int i1;
        Direction.Axis axis1 = AxisCycle.FORWARD.cycle(axis);
        Direction.Axis axis2 = AxisCycle.BACKWARD.cycle(axis);
        int i = this.findIndex(axis1, primaryPosition);
        int i2 = this.shape.lastFull(axis, i, i1 = this.findIndex(axis2, secondaryPosition));
        return i2 <= 0 ? Double.NEGATIVE_INFINITY : this.get(axis, i2);
    }

    protected int findIndex(Direction.Axis axis, double position) {
        double value = position;
        switch (axis) {
            case X: {
                double[] values = this.rootCoordinatesX;
                return CollisionUtil.findFloor(values, this.offsetX, value, 0, values.length - 1);
            }
            case Y: {
                double[] values = this.rootCoordinatesY;
                return CollisionUtil.findFloor(values, this.offsetY, value, 0, values.length - 1);
            }
            case Z: {
                double[] values = this.rootCoordinatesZ;
                return CollisionUtil.findFloor(values, this.offsetZ, value, 0, values.length - 1);
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    public @Nullable BlockHitResult clip(Vec3 startVec, Vec3 endVec, BlockPos pos) {
        if (this.isEmpty) {
            return null;
        }
        Vec3 directionOpposite = endVec.subtract(startVec);
        if (directionOpposite.lengthSqr() < 1.0E-7) {
            return null;
        }
        Vec3 fromBehind = startVec.add(directionOpposite.scale(0.001));
        double fromBehindOffsetX = fromBehind.x - (double)pos.getX();
        double fromBehindOffsetY = fromBehind.y - (double)pos.getY();
        double fromBehindOffsetZ = fromBehind.z - (double)pos.getZ();
        AABB singleAABB = this.singleAABBRepresentation;
        if (singleAABB != null) {
            if (singleAABB.contains(fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
                return new BlockHitResult(fromBehind, Direction.getApproximateNearest(directionOpposite.x, directionOpposite.y, directionOpposite.z).getOpposite(), pos, true);
            }
            return VoxelShape.clip(singleAABB, startVec, endVec, pos);
        }
        if (CollisionUtil.strictlyContains(this, fromBehindOffsetX, fromBehindOffsetY, fromBehindOffsetZ)) {
            return new BlockHitResult(fromBehind, Direction.getApproximateNearest(directionOpposite.x, directionOpposite.y, directionOpposite.z).getOpposite(), pos, true);
        }
        return AABB.clip(this.toAabbs(), startVec, endVec, pos);
    }

    public Optional<Vec3> closestPointTo(Vec3 point) {
        if (this.isEmpty) {
            return Optional.empty();
        }
        Vec3 ret = null;
        double retDistance = Double.MAX_VALUE;
        List<AABB> aabbs = this.toAabbs();
        int len = aabbs.size();
        for (int i = 0; i < len; ++i) {
            double z;
            double y;
            AABB aabb = aabbs.get(i);
            double x = Mth.clamp(point.x, aabb.minX, aabb.maxX);
            double dist = point.distanceToSqr(x, y = Mth.clamp(point.y, aabb.minY, aabb.maxY), z = Mth.clamp(point.z, aabb.minZ, aabb.maxZ));
            if (!(dist < retDistance)) continue;
            ret = new Vec3(x, y, z);
            retDistance = dist;
        }
        return Optional.ofNullable(ret);
    }

    public VoxelShape getFaceShape(Direction side) {
        if (!this.isEmpty() && this != Shapes.block()) {
            VoxelShape voxelShape;
            if (this.faces != null) {
                voxelShape = this.faces[side.ordinal()];
                if (voxelShape != null) {
                    return voxelShape;
                }
            } else {
                this.faces = new VoxelShape[6];
            }
            this.faces[side.ordinal()] = voxelShape = this.calculateFace(side);
            return voxelShape;
        }
        return this;
    }

    private VoxelShape calculateFace(Direction side) {
        Direction.Axis axis = side.getAxis();
        switch (axis) {
            case X: {
                return this.calculateFaceDirect(side, axis, this.rootCoordinatesX, this.offsetX);
            }
            case Y: {
                return this.calculateFaceDirect(side, axis, this.rootCoordinatesY, this.offsetY);
            }
            case Z: {
                return this.calculateFaceDirect(side, axis, this.rootCoordinatesZ, this.offsetZ);
            }
        }
        throw new IllegalStateException("Unknown axis: " + String.valueOf(axis));
    }

    protected boolean isCubeLike() {
        for (Direction.Axis axis : Direction.Axis.VALUES) {
            if (this.isCubeLikeAlong(axis)) continue;
            return false;
        }
        return true;
    }

    private boolean isCubeLikeAlong(Direction.Axis axis) {
        DoubleList coords = this.getCoords(axis);
        return coords.size() == 2 && DoubleMath.fuzzyEquals((double)coords.getDouble(0), (double)0.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)coords.getDouble(1), (double)1.0, (double)1.0E-7);
    }

    public double collide(Direction.Axis axis, AABB source, double source_move) {
        if (this.isEmpty) {
            return source_move;
        }
        if (Math.abs(source_move) < 1.0E-7) {
            return 0.0;
        }
        switch (axis) {
            case X: {
                return CollisionUtil.collideX(this, source, source_move);
            }
            case Y: {
                return CollisionUtil.collideY(this, source, source_move);
            }
            case Z: {
                return CollisionUtil.collideZ(this, source, source_move);
            }
        }
        throw new RuntimeException("Unknown axis: " + String.valueOf(axis));
    }

    protected double collideX(AxisCycle movementAxis, AABB collisionBox, double desiredOffset) {
        block11: {
            int min1;
            int min;
            double d1;
            Direction.Axis axis;
            AxisCycle axisCycle;
            block10: {
                if (this.isEmpty()) {
                    return desiredOffset;
                }
                if (Math.abs(desiredOffset) < 1.0E-7) {
                    return 0.0;
                }
                axisCycle = movementAxis.inverse();
                axis = axisCycle.cycle(Direction.Axis.X);
                Direction.Axis axis1 = axisCycle.cycle(Direction.Axis.Y);
                Direction.Axis axis2 = axisCycle.cycle(Direction.Axis.Z);
                double d = collisionBox.max(axis);
                d1 = collisionBox.min(axis);
                int i = this.findIndex(axis, d1 + 1.0E-7);
                int i1 = this.findIndex(axis, d - 1.0E-7);
                int max = Math.max(0, this.findIndex(axis1, collisionBox.min(axis1) + 1.0E-7));
                min = Math.min(this.shape.getSize(axis1), this.findIndex(axis1, collisionBox.max(axis1) - 1.0E-7) + 1);
                int max1 = Math.max(0, this.findIndex(axis2, collisionBox.min(axis2) + 1.0E-7));
                min1 = Math.min(this.shape.getSize(axis2), this.findIndex(axis2, collisionBox.max(axis2) - 1.0E-7) + 1);
                int size = this.shape.getSize(axis);
                if (!(desiredOffset > 0.0)) break block10;
                for (int i2 = i1 + 1; i2 < size; ++i2) {
                    for (int i3 = max; i3 < min; ++i3) {
                        for (int i4 = max1; i4 < min1; ++i4) {
                            if (!this.shape.isFullWide(axisCycle, i2, i3, i4)) continue;
                            double d2 = this.get(axis, i2) - d;
                            if (d2 >= -1.0E-7) {
                                desiredOffset = Math.min(desiredOffset, d2);
                            }
                            return desiredOffset;
                        }
                    }
                }
                break block11;
            }
            if (!(desiredOffset < 0.0)) break block11;
            for (int i2 = i - 1; i2 >= 0; --i2) {
                for (int i3 = max; i3 < min; ++i3) {
                    for (int i4x = max1; i4x < min1; ++i4x) {
                        if (!this.shape.isFullWide(axisCycle, i2, i3, i4x)) continue;
                        double d2 = this.get(axis, i2 + 1) - d1;
                        if (d2 <= 1.0E-7) {
                            desiredOffset = Math.max(desiredOffset, d2);
                        }
                        return desiredOffset;
                    }
                }
            }
        }
        return desiredOffset;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public String toString() {
        return this.isEmpty() ? "EMPTY" : "VoxelShape[" + String.valueOf(this.bounds()) + "]";
    }
}

