/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.mojang.serialization.DataResult;
import io.papermc.paper.util.Holderable;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.gamerules.GameRuleType;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.CraftRegistry;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class CraftGameRule<T>
extends GameRule<T>
implements Holderable<net.minecraft.world.level.gamerules.GameRule<T>> {
    public static final BiFunction<String, DataResult.Error<?>, IllegalArgumentException> INVALID_VALUE = (value, error) -> new IllegalArgumentException("Invalid value: %s (%s)".formatted(value, error.message()));
    private final Holder<net.minecraft.world.level.gamerules.GameRule<T>> holder;

    public static <T> GameRule<T> minecraftToBukkit(net.minecraft.world.level.gamerules.GameRule<T> minecraft) {
        return (GameRule)CraftRegistry.minecraftToBukkit(minecraft, Registries.GAME_RULE);
    }

    public static <T> net.minecraft.world.level.gamerules.GameRule<T> bukkitToMinecraft(GameRule<T> bukkit) {
        return (net.minecraft.world.level.gamerules.GameRule)CraftRegistry.bukkitToMinecraft(bukkit);
    }

    public CraftGameRule(Holder<net.minecraft.world.level.gamerules.GameRule<?>> holder) {
        this.holder = holder;
    }

    public static <LEGACY, MODERN> GameRule<LEGACY> wrap(GameRule<MODERN> rule, Function<LEGACY, MODERN> fromLegacyToModern, Function<MODERN, LEGACY> toLegacyFromModern, Class<LEGACY> legacyClass) {
        return new LegacyGameRuleWrapper<LEGACY, MODERN>(((CraftGameRule)rule).getHolder(), fromLegacyToModern, toLegacyFromModern, legacyClass);
    }

    @Override
    public Holder<net.minecraft.world.level.gamerules.GameRule<T>> getHolder() {
        return this.holder;
    }

    @Override
    public NamespacedKey getKey() {
        return Holderable.super.getKey();
    }

    public int hashCode() {
        return Holderable.super.implHashCode();
    }

    public boolean equals(Object obj) {
        return Holderable.super.implEquals(obj);
    }

    public String toString() {
        return Holderable.super.implToString();
    }

    public String getName() {
        return this.holder.getRegisteredName();
    }

    public Class<T> getType() {
        return switch (((net.minecraft.world.level.gamerules.GameRule)this.getHandle()).gameRuleType()) {
            default -> throw new MatchException(null, null);
            case GameRuleType.INT -> Integer.class;
            case GameRuleType.BOOL -> Boolean.class;
        };
    }

    public String translationKey() {
        return ((net.minecraft.world.level.gamerules.GameRule)this.getHandle()).getDescriptionId();
    }

    public static class LegacyGameRuleWrapper<LEGACY, MODERN>
    extends CraftGameRule<LEGACY> {
        private final Class<LEGACY> typeOverride;
        private final Function<LEGACY, MODERN> fromLegacyToModern;
        private final Function<MODERN, LEGACY> toLegacyFromModern;

        public LegacyGameRuleWrapper(Holder<net.minecraft.world.level.gamerules.GameRule<?>> holder, Function<LEGACY, MODERN> fromLegacyToModern, Function<MODERN, LEGACY> toLegacyFromModern, Class<LEGACY> typeOverride) {
            super(holder);
            this.fromLegacyToModern = fromLegacyToModern;
            this.toLegacyFromModern = toLegacyFromModern;
            this.typeOverride = typeOverride;
        }

        public Function<LEGACY, MODERN> getFromLegacyToModern() {
            return this.fromLegacyToModern;
        }

        public Function<MODERN, LEGACY> getToLegacyFromModern() {
            return this.toLegacyFromModern;
        }

        @Override
        public Class<LEGACY> getType() {
            return this.typeOverride;
        }
    }
}

