/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.dedicated.DedicatedServer;
import org.bukkit.ServerLinks;
import org.bukkit.craftbukkit.util.CraftChatMessage;

public class CraftServerLinks
implements ServerLinks {
    private final DedicatedServer server;
    private net.minecraft.server.ServerLinks serverLinks;

    public CraftServerLinks(DedicatedServer server) {
        this(server, null);
    }

    public CraftServerLinks(net.minecraft.server.ServerLinks serverLinks) {
        this(null, serverLinks);
    }

    private CraftServerLinks(DedicatedServer server, net.minecraft.server.ServerLinks serverLinks) {
        this.server = server;
        this.serverLinks = serverLinks;
    }

    public ServerLinks.ServerLink getLink(ServerLinks.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        return this.getServerLinks().findKnownType(CraftServerLinks.fromBukkit(type)).map(CraftServerLink::new).orElse(null);
    }

    public List<ServerLinks.ServerLink> getLinks() {
        return this.getServerLinks().entries().stream().map(nms -> new CraftServerLink((ServerLinks.Entry)nms)).toList();
    }

    public ServerLinks.ServerLink setLink(ServerLinks.Type type, URI url) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        ServerLinks.ServerLink existing = this.getLink(type);
        if (existing != null) {
            this.removeLink(existing);
        }
        return this.addLink(type, url);
    }

    public ServerLinks.ServerLink addLink(ServerLinks.Type type, URI url) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        CraftServerLink link = new CraftServerLink(ServerLinks.Entry.knownType(CraftServerLinks.fromBukkit(type), url));
        this.addLink(link);
        return link;
    }

    public ServerLinks.ServerLink addLink(Component displayName, URI url) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"displayName cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        CraftServerLink link = new CraftServerLink(ServerLinks.Entry.custom(PaperAdventure.asVanilla(displayName), url));
        this.addLink(link);
        return link;
    }

    public ServerLinks.ServerLink addLink(String displayName, URI url) {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"displayName cannot be null");
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"url cannot be null");
        CraftServerLink link = new CraftServerLink(ServerLinks.Entry.custom(CraftChatMessage.fromStringOrNull(displayName), url));
        this.addLink(link);
        return link;
    }

    private void addLink(CraftServerLink link) {
        ArrayList<ServerLinks.Entry> lst = new ArrayList<ServerLinks.Entry>(this.getServerLinks().entries());
        lst.add(link.handle);
        this.setLinks(new net.minecraft.server.ServerLinks(lst));
    }

    public boolean removeLink(ServerLinks.ServerLink link) {
        Preconditions.checkArgument((link != null ? 1 : 0) != 0, (Object)"link cannot be null");
        ArrayList<ServerLinks.Entry> lst = new ArrayList<ServerLinks.Entry>(this.getServerLinks().entries());
        boolean result = lst.remove(((CraftServerLink)link).handle);
        this.setLinks(new net.minecraft.server.ServerLinks(lst));
        return result;
    }

    public ServerLinks copy() {
        return new CraftServerLinks(this.getServerLinks());
    }

    public net.minecraft.server.ServerLinks getServerLinks() {
        return this.server != null ? this.server.serverLinks() : this.serverLinks;
    }

    private void setLinks(net.minecraft.server.ServerLinks links) {
        if (this.server != null) {
            this.server.serverLinks = links;
        } else {
            this.serverLinks = links;
        }
    }

    private static ServerLinks.KnownLinkType fromBukkit(ServerLinks.Type type) {
        return ServerLinks.KnownLinkType.values()[type.ordinal()];
    }

    private static ServerLinks.Type fromNMS(ServerLinks.KnownLinkType nms) {
        return ServerLinks.Type.values()[nms.ordinal()];
    }

    public static class CraftServerLink
    implements ServerLinks.ServerLink {
        private final ServerLinks.Entry handle;

        public CraftServerLink(ServerLinks.Entry handle) {
            this.handle = handle;
        }

        public ServerLinks.Type getType() {
            return this.handle.type().left().map(CraftServerLinks::fromNMS).orElse(null);
        }

        public String getDisplayName() {
            return CraftChatMessage.fromComponent(this.handle.displayName());
        }

        public Component displayName() {
            return PaperAdventure.asAdventure(this.handle.displayName());
        }

        public URI getUrl() {
            return this.handle.link();
        }
    }
}

