/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.border.WorldBorder;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.craftbukkit.CraftWorld;

public class CraftWorldBorder
implements WorldBorder {
    private final World world;
    private final net.minecraft.world.level.border.WorldBorder handle;

    public CraftWorldBorder(CraftWorld world) {
        this.world = world;
        this.handle = world.getHandle().getWorldBorder();
    }

    public CraftWorldBorder(net.minecraft.world.level.border.WorldBorder handle) {
        this.world = null;
        this.handle = handle;
    }

    public World getWorld() {
        return this.world;
    }

    public void reset() {
        this.getHandle().applySettings(WorldBorder.Settings.DEFAULT);
    }

    public double getSize() {
        return this.handle.getSize();
    }

    public void setSize(double newSize) {
        Preconditions.checkArgument((newSize >= 1.0 && newSize <= this.getMaxSize() ? 1 : 0) != 0, (String)"newSize must be between 1.0D and %s", (Object)this.getMaxSize());
        this.handle.setSize(newSize);
    }

    public void changeSize(double newSize, long ticks) {
        Preconditions.checkArgument((ticks >= 0L && ticks <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"ticks must be between 0-%s", (int)Integer.MAX_VALUE);
        Preconditions.checkArgument((newSize >= 1.0 && newSize <= this.getMaxSize() ? 1 : 0) != 0, (String)"newSize must be between 1.0D and %s", (Object)this.getMaxSize());
        if (ticks > 0L) {
            long startTime = this.getWorld() != null ? this.getWorld().getGameTime() : 0L;
            this.handle.lerpSizeBetween(this.handle.getSize(), newSize, ticks, startTime);
        } else {
            this.handle.setSize(newSize);
        }
    }

    public Location getCenter() {
        double x = this.handle.getCenterX();
        double z = this.handle.getCenterZ();
        return new Location(this.world, x, 0.0, z);
    }

    public void setCenter(double x, double z) {
        Preconditions.checkArgument((Math.abs(x) <= this.getMaxCenterCoordinate() ? 1 : 0) != 0, (String)"x coordinate cannot be outside +- %s", (Object)this.getMaxCenterCoordinate());
        Preconditions.checkArgument((Math.abs(z) <= this.getMaxCenterCoordinate() ? 1 : 0) != 0, (String)"z coordinate cannot be outside +- %s", (Object)this.getMaxCenterCoordinate());
        this.handle.setCenter(x, z);
    }

    public void setCenter(Location location) {
        this.setCenter(location.getX(), location.getZ());
    }

    public double getDamageBuffer() {
        return this.handle.getSafeZone();
    }

    public void setDamageBuffer(double blocks) {
        this.handle.setSafeZone(blocks);
    }

    public double getDamageAmount() {
        return this.handle.getDamagePerBlock();
    }

    public void setDamageAmount(double damage) {
        this.handle.setDamagePerBlock(damage);
    }

    public int getWarningTimeTicks() {
        return this.handle.getWarningTime();
    }

    public void setWarningTimeTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks cannot be lower than 0");
        this.handle.setWarningTime(ticks);
    }

    public int getWarningDistance() {
        return this.handle.getWarningBlocks();
    }

    public void setWarningDistance(int distance) {
        this.handle.setWarningBlocks(distance);
    }

    public boolean isInside(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        return (this.world == null || location.getWorld().equals((Object)this.world)) && this.handle.isWithinBounds(BlockPos.containing(location.getX(), location.getY(), location.getZ()));
    }

    public double getMaxSize() {
        return 5.9999968E7;
    }

    public double getMaxCenterCoordinate() {
        return 2.9999984E7;
    }

    public net.minecraft.world.level.border.WorldBorder getHandle() {
        return this.handle;
    }

    public boolean isVirtual() {
        return this.world == null;
    }
}

