/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.EnchantingTable;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.util.CraftChatMessage;

public class CraftEnchantingTable
extends CraftBlockEntityState<EnchantingTableBlockEntity>
implements EnchantingTable {
    public CraftEnchantingTable(World world, EnchantingTableBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftEnchantingTable(CraftEnchantingTable state, Location location) {
        super(state, location);
    }

    public Component customName() {
        EnchantingTableBlockEntity enchantingTable = (EnchantingTableBlockEntity)this.getSnapshot();
        return enchantingTable.hasCustomName() ? PaperAdventure.asAdventure(enchantingTable.getCustomName()) : null;
    }

    public void customName(Component customName) {
        ((EnchantingTableBlockEntity)this.getSnapshot()).setCustomName(customName != null ? PaperAdventure.asVanilla(customName) : null);
    }

    public String getCustomName() {
        EnchantingTableBlockEntity enchant = (EnchantingTableBlockEntity)this.getSnapshot();
        return enchant.hasCustomName() ? CraftChatMessage.fromComponent(enchant.getCustomName()) : null;
    }

    public void setCustomName(String name) {
        ((EnchantingTableBlockEntity)this.getSnapshot()).setCustomName(CraftChatMessage.fromStringOrNull(name));
    }

    @Override
    public void applyTo(EnchantingTableBlockEntity blockEntity) {
        super.applyTo(blockEntity);
        if (!((EnchantingTableBlockEntity)this.getSnapshot()).hasCustomName()) {
            blockEntity.setCustomName(null);
        }
    }

    @Override
    public CraftEnchantingTable copy() {
        return new CraftEnchantingTable(this, null);
    }

    @Override
    public CraftEnchantingTable copy(Location location) {
        return new CraftEnchantingTable(this, location);
    }
}

