/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.block;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.SharedPlayerProfile;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.Util;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.SkullType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Rotatable;
import org.bukkit.craftbukkit.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.jetbrains.annotations.Nullable;

public class CraftSkull
extends CraftBlockEntityState<SkullBlockEntity>
implements Skull {
    private static final int MAX_OWNER_LENGTH = 16;
    private ResolvableProfile profile;

    public CraftSkull(World world, SkullBlockEntity blockEntity) {
        super(world, blockEntity);
    }

    protected CraftSkull(CraftSkull state, Location location) {
        super(state, location);
    }

    @Override
    public void load(SkullBlockEntity blockEntity) {
        super.load(blockEntity);
        ResolvableProfile owner = blockEntity.getOwnerProfile();
        if (owner != null) {
            this.profile = owner;
        }
    }

    public io.papermc.paper.datacomponent.item.ResolvableProfile getProfile() {
        if (this.profile == null) {
            return null;
        }
        return new PaperResolvableProfile(this.profile);
    }

    public void setProfile(io.papermc.paper.datacomponent.item.ResolvableProfile profile) {
        if (profile == null) {
            this.profile = null;
            return;
        }
        this.profile = ((PaperResolvableProfile)profile).getHandle();
    }

    public boolean hasOwner() {
        return this.profile != null;
    }

    public String getOwner() {
        return this.hasOwner() ? (String)this.profile.name().orElse(null) : null;
    }

    public boolean setOwner(String name) {
        if (name == null || name.length() > 16) {
            return false;
        }
        GameProfile profile = MinecraftServer.getServer().services().paper().filledProfileCache().getIfCached(name);
        if (profile == null) {
            profile = MinecraftServer.getServer().services().nameToIdCache().get(name).map(NameAndId::toUncompletedGameProfile).orElse(null);
        }
        if (profile == null) {
            return false;
        }
        this.profile = ResolvableProfile.createResolved(profile);
        return true;
    }

    public OfflinePlayer getOwningPlayer() {
        if (this.hasOwner()) {
            GameProfile gameProfile = this.profile.partialProfile();
            if (!gameProfile.id().equals(Util.NIL_UUID)) {
                return Bukkit.getOfflinePlayer((UUID)gameProfile.id());
            }
            if (!gameProfile.name().isEmpty()) {
                return Bukkit.getOfflinePlayer((String)gameProfile.name());
            }
        }
        return null;
    }

    public void setOwningPlayer(OfflinePlayer player) {
        Preconditions.checkNotNull((Object)player, (Object)"player");
        if (player instanceof CraftPlayer) {
            CraftPlayer craftPlayer = (CraftPlayer)player;
            this.profile = ResolvableProfile.createResolved(craftPlayer.getProfile());
        } else {
            this.profile = new ResolvableProfile.Dynamic(Either.right(player.getUniqueId()), PlayerSkin.Patch.EMPTY);
        }
    }

    public void setPlayerProfile(PlayerProfile profile) {
        Preconditions.checkNotNull((Object)profile, (Object)"profile");
        this.profile = com.destroystokyo.paper.profile.CraftPlayerProfile.asResolvableProfileCopy(profile);
    }

    @javax.annotation.Nullable
    public PlayerProfile getPlayerProfile() {
        return this.profile != null ? new com.destroystokyo.paper.profile.CraftPlayerProfile(this.profile) : null;
    }

    @Deprecated
    public org.bukkit.profile.PlayerProfile getOwnerProfile() {
        if (!this.hasOwner()) {
            return null;
        }
        return new CraftPlayerProfile(this.profile);
    }

    @Deprecated
    public void setOwnerProfile(org.bukkit.profile.PlayerProfile profile) {
        this.profile = profile == null ? null : ((SharedPlayerProfile)profile).buildResolvableProfile();
    }

    public NamespacedKey getNoteBlockSound() {
        Identifier key = ((SkullBlockEntity)this.getSnapshot()).getNoteBlockSound();
        return key != null ? CraftNamespacedKey.fromMinecraft(key) : null;
    }

    public void setNoteBlockSound(@Nullable NamespacedKey namespacedKey) {
        if (namespacedKey == null) {
            ((SkullBlockEntity)this.getSnapshot()).noteBlockSound = null;
            return;
        }
        ((SkullBlockEntity)this.getSnapshot()).noteBlockSound = CraftNamespacedKey.toMinecraft(namespacedKey);
    }

    public BlockFace getRotation() {
        BlockFace blockFace;
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Rotatable) {
            Rotatable rotatable = (Rotatable)blockData;
            blockFace = rotatable.getRotation();
        } else {
            blockFace = ((Directional)blockData).getFacing();
        }
        return blockFace;
    }

    public void setRotation(BlockFace rotation) {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Rotatable) {
            ((Rotatable)blockData).setRotation(rotation);
        } else {
            ((Directional)blockData).setFacing(rotation);
        }
        this.setBlockData(blockData);
    }

    public SkullType getSkullType() {
        switch (this.getType()) {
            case SKELETON_SKULL: 
            case SKELETON_WALL_SKULL: {
                return SkullType.SKELETON;
            }
            case WITHER_SKELETON_SKULL: 
            case WITHER_SKELETON_WALL_SKULL: {
                return SkullType.WITHER;
            }
            case ZOMBIE_HEAD: 
            case ZOMBIE_WALL_HEAD: {
                return SkullType.ZOMBIE;
            }
            case PIGLIN_HEAD: 
            case PIGLIN_WALL_HEAD: {
                return SkullType.PIGLIN;
            }
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: {
                return SkullType.PLAYER;
            }
            case CREEPER_HEAD: 
            case CREEPER_WALL_HEAD: {
                return SkullType.CREEPER;
            }
            case DRAGON_HEAD: 
            case DRAGON_WALL_HEAD: {
                return SkullType.DRAGON;
            }
        }
        throw new IllegalArgumentException("Unknown SkullType for " + String.valueOf(this.getType()));
    }

    public void setSkullType(SkullType skullType) {
        throw new UnsupportedOperationException("Must change block type");
    }

    @Override
    public void applyTo(SkullBlockEntity blockEntity) {
        super.applyTo(blockEntity);
        if (this.getSkullType() == SkullType.PLAYER) {
            blockEntity.owner = this.hasOwner() ? this.profile : null;
        }
    }

    @Override
    public CraftSkull copy() {
        return new CraftSkull(this, null);
    }

    @Override
    public CraftSkull copy(Location location) {
        return new CraftSkull(this, location);
    }

    @Nullable
    public Component customName() {
        SkullBlockEntity snapshot = (SkullBlockEntity)this.getSnapshot();
        return snapshot.customName == null ? null : PaperAdventure.asAdventure(snapshot.customName);
    }

    public void customName(@Nullable Component customName) {
        SkullBlockEntity snapshot = (SkullBlockEntity)this.getSnapshot();
        snapshot.customName = customName == null ? null : PaperAdventure.asVanilla(customName);
    }
}

