/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.commands.PaperCommandBlockHolder;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.vehicle.minecart.MinecartCommandBlock;
import net.minecraft.world.level.BaseCommandBlock;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftMinecart;
import org.bukkit.craftbukkit.util.CraftChatMessage;
import org.bukkit.entity.minecart.CommandMinecart;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CraftMinecartCommand
extends CraftMinecart
implements CommandMinecart,
PaperCommandBlockHolder {
    private final PermissibleBase perm = new PermissibleBase((ServerOperator)this);

    public CraftMinecartCommand(CraftServer server, MinecartCommandBlock entity) {
        super(server, entity);
    }

    @Override
    public MinecartCommandBlock getHandle() {
        return (MinecartCommandBlock)this.entity;
    }

    public String getCommand() {
        return this.getHandle().getCommandBlock().getCommand();
    }

    public void setCommand(String command) {
        this.getHandle().getCommandBlock().setCommand(command != null ? command : "");
        this.getHandle().getEntityData().set(MinecartCommandBlock.DATA_ID_COMMAND_NAME, this.getHandle().getCommandBlock().getCommand());
    }

    public void setName(String name) {
        this.getHandle().getCommandBlock().setCustomName(CraftChatMessage.fromStringOrNull(name));
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public void sendMessage(String ... messages) {
    }

    @Override
    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().getCommandBlock().getName());
    }

    @Override
    public @NotNull Component name() {
        return PaperAdventure.asAdventure(this.getHandle().getCommandBlock().getName());
    }

    @Override
    public BaseCommandBlock getCommandBlockHandle() {
        return this.getHandle().getCommandBlock();
    }

    @Override
    public void lastOutput(Component lastOutput) {
        PaperCommandBlockHolder.super.lastOutput(lastOutput);
        this.getCommandBlockHandle().onUpdated((ServerLevel)this.getHandle().level());
    }

    @Override
    public boolean isOp() {
        return true;
    }

    @Override
    public void setOp(boolean value) {
        throw new UnsupportedOperationException("Cannot change operator status of a minecart");
    }

    @Override
    public boolean isPermissionSet(String name) {
        return this.perm.isPermissionSet(name);
    }

    @Override
    public boolean isPermissionSet(Permission perm) {
        return this.perm.isPermissionSet(perm);
    }

    @Override
    public boolean hasPermission(String name) {
        return this.perm.hasPermission(name);
    }

    @Override
    public boolean hasPermission(Permission perm) {
        return this.perm.hasPermission(perm);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return this.perm.addAttachment(plugin, name, value);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin) {
        return this.perm.addAttachment(plugin);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return this.perm.addAttachment(plugin, name, value, ticks);
    }

    @Override
    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return this.perm.addAttachment(plugin, ticks);
    }

    @Override
    public void removeAttachment(PermissionAttachment attachment) {
        this.perm.removeAttachment(attachment);
    }

    @Override
    public void recalculatePermissions() {
        this.perm.recalculatePermissions();
    }

    @Override
    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return this.perm.getEffectivePermissions();
    }

    @Override
    public Server getServer() {
        return Bukkit.getServer();
    }
}

