/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.panda.Panda;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftAnimals;
import org.bukkit.entity.Panda;

public class CraftPanda
extends CraftAnimals
implements Panda {
    public CraftPanda(CraftServer server, net.minecraft.world.entity.animal.panda.Panda entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.animal.panda.Panda getHandle() {
        return (net.minecraft.world.entity.animal.panda.Panda)this.entity;
    }

    public Panda.Gene getMainGene() {
        return CraftPanda.fromNms(this.getHandle().getMainGene());
    }

    public void setMainGene(Panda.Gene gene) {
        this.getHandle().setMainGene(CraftPanda.toNms(gene));
    }

    public Panda.Gene getHiddenGene() {
        return CraftPanda.fromNms(this.getHandle().getHiddenGene());
    }

    public void setHiddenGene(Panda.Gene gene) {
        this.getHandle().setHiddenGene(CraftPanda.toNms(gene));
    }

    public void setSneezeTicks(int ticks) {
        this.getHandle().setSneezeCounter(ticks);
    }

    public int getSneezeTicks() {
        return this.getHandle().getSneezeCounter();
    }

    public void setEatingTicks(int ticks) {
        this.getHandle().setEatCounter(ticks);
    }

    public int getEatingTicks() {
        return this.getHandle().getEatCounter();
    }

    public void setUnhappyTicks(int ticks) {
        this.getHandle().setUnhappyCounter(ticks);
    }

    public Panda.Gene getCombinedGene() {
        return CraftPanda.fromNms(this.getHandle().getVariant());
    }

    public boolean isRolling() {
        return this.getHandle().isRolling();
    }

    public void setRolling(boolean flag) {
        this.getHandle().roll(flag);
    }

    public boolean isSneezing() {
        return this.getHandle().isSneezing();
    }

    public void setSneezing(boolean flag) {
        this.getHandle().sneeze(flag);
    }

    public boolean isSitting() {
        return this.getHandle().isSitting();
    }

    public void setSitting(boolean flag) {
        this.getHandle().sit(flag);
    }

    public boolean isOnBack() {
        return this.getHandle().isOnBack();
    }

    public void setOnBack(boolean flag) {
        this.getHandle().setOnBack(flag);
    }

    public boolean isEating() {
        return this.getHandle().isEating();
    }

    public void setEating(boolean flag) {
        this.getHandle().eat(flag);
    }

    public boolean isScared() {
        return this.getHandle().isScared();
    }

    public int getUnhappyTicks() {
        return this.getHandle().getUnhappyCounter();
    }

    public static Panda.Gene fromNms(Panda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }

    public static Panda.Gene toNms(Panda.Gene gene) {
        Preconditions.checkArgument((gene != null ? 1 : 0) != 0, (Object)"Gene may not be null");
        return Panda.Gene.values()[gene.ordinal()];
    }
}

