/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.illager.SpellcasterIllager;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftIllager;
import org.bukkit.entity.Spellcaster;

public class CraftSpellcaster
extends CraftIllager
implements Spellcaster {
    public CraftSpellcaster(CraftServer server, SpellcasterIllager entity) {
        super(server, entity);
    }

    @Override
    public SpellcasterIllager getHandle() {
        return (SpellcasterIllager)this.entity;
    }

    public Spellcaster.Spell getSpell() {
        return CraftSpellcaster.toBukkitSpell(this.getHandle().getCurrentSpell());
    }

    public void setSpell(Spellcaster.Spell spell) {
        Preconditions.checkArgument((spell != null ? 1 : 0) != 0, (Object)"Use Spell.NONE");
        this.getHandle().setIsCastingSpell(CraftSpellcaster.toNMSSpell(spell));
    }

    public static Spellcaster.Spell toBukkitSpell(SpellcasterIllager.IllagerSpell spell) {
        return Spellcaster.Spell.valueOf((String)spell.name());
    }

    public static SpellcasterIllager.IllagerSpell toNMSSpell(Spellcaster.Spell spell) {
        return SpellcasterIllager.IllagerSpell.byId(spell.ordinal());
    }
}

