/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.entity;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.projectile.throwableitemprojectile.AbstractThrownPotion;
import net.minecraft.world.item.alchemy.PotionContents;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftThrowableProjectile;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.potion.CraftPotionUtil;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public abstract class CraftThrownPotion
extends CraftThrowableProjectile
implements ThrownPotion {
    protected CraftThrownPotion(CraftServer server, AbstractThrownPotion entity) {
        super(server, entity);
    }

    @Override
    public AbstractThrownPotion getHandle() {
        return (AbstractThrownPotion)this.entity;
    }

    public Collection<PotionEffect> getEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffectInstance effect : this.getHandle().getItem().getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).getAllEffects()) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().getItem());
    }

    public void setPotionMeta(PotionMeta meta) {
        net.minecraft.world.item.ItemStack item = this.getHandle().getItem();
        CraftItemStack.applyMetaToItem(item, (ItemMeta)meta);
        this.getHandle().setItem(item);
    }

    public void splash() {
        this.getHandle().splash(null);
    }
}

