/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.SaddledMountInventory;

public class CraftInventorySaddledMount
extends CraftInventory
implements SaddledMountInventory {
    private final Container bodyArmorInventory;
    private final Container saddleInventory;

    public CraftInventorySaddledMount(Container inventory, Container bodyArmorInventory, Container saddleInventory) {
        super(inventory);
        this.bodyArmorInventory = bodyArmorInventory;
        this.saddleInventory = saddleInventory;
    }

    public org.bukkit.inventory.ItemStack getSaddle() {
        return this.getItem(0);
    }

    public void setSaddle(org.bukkit.inventory.ItemStack stack) {
        this.setItem(0, stack);
    }

    public Container getMainInventory() {
        return this.inventory;
    }

    public Container getArmorInventory() {
        return this.bodyArmorInventory;
    }

    public Container getSaddleInventory() {
        return this.saddleInventory;
    }

    public org.bukkit.inventory.ItemStack getArmor() {
        return this.getItem(1);
    }

    public void setArmor(org.bukkit.inventory.ItemStack armor) {
        this.setItem(1, armor);
    }

    @Override
    public int getSize() {
        return this.getMainInventory().getContainerSize() + this.getArmorInventory().getContainerSize() + this.getSaddleInventory().getContainerSize();
    }

    @Override
    public boolean isEmpty() {
        return this.getMainInventory().isEmpty() && this.getArmorInventory().isEmpty() && this.getSaddleInventory().isEmpty();
    }

    @Override
    public org.bukkit.inventory.ItemStack[] getContents() {
        org.bukkit.inventory.ItemStack[] items = new org.bukkit.inventory.ItemStack[this.getSize()];
        items[0] = this.getSaddle();
        items[1] = this.getArmor();
        for (int i = 2; i < items.length; ++i) {
            ItemStack item = this.getMainInventory().getItem(i - 2);
            items[i] = item.isEmpty() ? null : CraftItemStack.asCraftMirror(item);
        }
        return items;
    }

    @Override
    public void setContents(org.bukkit.inventory.ItemStack[] items) {
        Preconditions.checkArgument((items.length <= this.getSize() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)items.length, (int)this.getSize());
        this.setSaddle((org.bukkit.inventory.ItemStack)ArrayUtils.get((Object[])items, (int)0));
        this.setArmor((org.bukkit.inventory.ItemStack)ArrayUtils.get((Object[])items, (int)1));
        for (int i = 2; i < this.getSize(); ++i) {
            ItemStack item = i >= items.length ? ItemStack.EMPTY : CraftItemStack.asNMSCopy(items[i]);
            this.getMainInventory().setItem(i - 2, item);
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getItem(int index) {
        ItemStack item;
        if (index == 0) {
            ItemStack item2 = this.getSaddleInventory().getItem(0);
            return item2.isEmpty() ? null : CraftItemStack.asCraftMirror(item2);
        }
        if (index == 1) {
            ItemStack item3 = this.getArmorInventory().getItem(0);
            return item3.isEmpty() ? null : CraftItemStack.asCraftMirror(item3);
        }
        int shiftedIndex = index;
        if (index > 0) {
            --shiftedIndex;
        }
        if (index > 1) {
            --shiftedIndex;
        }
        return (item = this.getMainInventory().getItem(shiftedIndex)).isEmpty() ? null : CraftItemStack.asCraftMirror(item);
    }

    @Override
    public void setItem(int index, org.bukkit.inventory.ItemStack item) {
        if (index == 0) {
            this.getSaddleInventory().setItem(0, CraftItemStack.asNMSCopy(item));
        } else if (index == 1) {
            this.getArmorInventory().setItem(0, CraftItemStack.asNMSCopy(item));
        } else {
            int shiftedIndex = index;
            if (index > 0) {
                --shiftedIndex;
            }
            if (index > 1) {
                --shiftedIndex;
            }
            this.getMainInventory().setItem(shiftedIndex, CraftItemStack.asNMSCopy(item));
        }
    }
}

