/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.inventory.components;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.JukeboxPlayable;
import org.bukkit.JukeboxSong;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.CraftJukeboxSong;
import org.bukkit.craftbukkit.CraftRegistry;
import org.bukkit.craftbukkit.inventory.SerializableMeta;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;

@SerializableAs(value="JukeboxPlayable")
public final class CraftJukeboxComponent
implements JukeboxPlayableComponent {
    private JukeboxPlayable handle;

    public CraftJukeboxComponent(JukeboxPlayable jukebox) {
        this.handle = jukebox;
    }

    public CraftJukeboxComponent(CraftJukeboxComponent jukebox) {
        this.handle = jukebox.handle;
    }

    public CraftJukeboxComponent(Map<String, Object> map) {
        String song = SerializableMeta.getObject(String.class, map, "song", false);
        this.handle = new JukeboxPlayable(new EitherHolder<net.minecraft.world.item.JukeboxSong>(ResourceKey.create(Registries.JUKEBOX_SONG, Identifier.parse(song))));
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("song", this.getSongKey().toString());
        return result;
    }

    public JukeboxPlayable getHandle() {
        return this.handle;
    }

    public JukeboxSong getSong() {
        Optional<Holder<net.minecraft.world.item.JukeboxSong>> song = this.handle.song().unwrap(CraftRegistry.getMinecraftRegistry());
        return song.map(CraftJukeboxSong::minecraftHolderToBukkit).orElse(null);
    }

    public NamespacedKey getSongKey() {
        return CraftNamespacedKey.fromMinecraft(this.handle.song().key().orElseThrow().identifier());
    }

    public void setSong(JukeboxSong song) {
        Preconditions.checkArgument((song != null ? 1 : 0) != 0, (Object)"song cannot be null");
        this.handle = new JukeboxPlayable(new EitherHolder<net.minecraft.world.item.JukeboxSong>(CraftJukeboxSong.bukkitToMinecraftHolder(song)));
    }

    public void setSongKey(NamespacedKey song) {
        Preconditions.checkArgument((song != null ? 1 : 0) != 0, (Object)"song cannot be null");
        this.handle = new JukeboxPlayable(new EitherHolder<net.minecraft.world.item.JukeboxSong>(ResourceKey.create(Registries.JUKEBOX_SONG, CraftNamespacedKey.toMinecraft(song))));
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.handle.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CraftJukeboxComponent other = (CraftJukeboxComponent)obj;
        return this.handle.equals(other.handle);
    }

    public String toString() {
        return "CraftJukeboxComponent{component=" + String.valueOf(this.handle) + "}";
    }
}

