/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.util;

import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import org.bukkit.NamespacedKey;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class CraftNamespacedKey {
    public static NamespacedKey fromString(String string) {
        return CraftNamespacedKey.fromMinecraft(Identifier.parse(string));
    }

    public static NamespacedKey fromMinecraft(Identifier minecraft) {
        return new NamespacedKey(minecraft.getNamespace(), minecraft.getPath());
    }

    public static Identifier toMinecraft(NamespacedKey key) {
        return Identifier.fromNamespaceAndPath(key.getNamespace(), key.getKey());
    }

    public static NamespacedKey fromResourceKey(ResourceKey<?> key) {
        return CraftNamespacedKey.fromMinecraft(key.identifier());
    }

    public static <T> ResourceKey<T> toResourceKey(ResourceKey<? extends Registry<T>> registry, NamespacedKey namespacedKey) {
        return ResourceKey.create(registry, CraftNamespacedKey.toMinecraft(namespacedKey));
    }
}

