/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerItemConsumeEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final EquipmentSlot hand;
    private ItemStack item;
    @Nullable
    private ItemStack replacement;
    private boolean cancelled;

    @ApiStatus.Internal
    public PlayerItemConsumeEvent(@NotNull Player player, @NotNull ItemStack item, @NotNull EquipmentSlot hand) {
        super(player);
        this.item = item;
        this.hand = hand;
    }

    @Deprecated(since="1.19.2", forRemoval=true)
    @ApiStatus.Internal
    public PlayerItemConsumeEvent(@NotNull Player player, @NotNull ItemStack item) {
        this(player, item, EquipmentSlot.HAND);
    }

    @NotNull
    public ItemStack getItem() {
        return this.item.clone();
    }

    public void setItem(@Nullable ItemStack item) {
        this.item = item == null ? new ItemStack(Material.AIR) : item;
    }

    @NotNull
    public EquipmentSlot getHand() {
        return this.hand;
    }

    @Nullable
    public ItemStack getReplacement() {
        return this.replacement;
    }

    public void setReplacement(@Nullable ItemStack replacement) {
        this.replacement = replacement;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

