/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.serialize;

import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.FunctionScalarSerializer;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.CheckedFunction;

public interface TypeSerializer<T> {
    public static <T> ScalarSerializer<T> of(Type type, BiFunction<T, Predicate<Class<?>>, Object> serializer, CheckedFunction<Object, T, SerializationException> deserializer) {
        return new FunctionScalarSerializer<T>(type, deserializer, serializer);
    }

    public static <T> ScalarSerializer<T> of(Class<T> type, BiFunction<T, Predicate<Class<?>>, Object> serializer, CheckedFunction<Object, T, SerializationException> deserializer) {
        if (type.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Parameterized types must be specified using TypeTokens, not raw classes");
        }
        return new FunctionScalarSerializer<T>(type, deserializer, serializer);
    }

    default public T deserialize(AnnotatedType type, ConfigurationNode node) throws SerializationException {
        return this.deserialize(type.getType(), node);
    }

    public T deserialize(Type var1, ConfigurationNode var2) throws SerializationException;

    default public void serialize(AnnotatedType type, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        this.serialize(type.getType(), obj, node);
    }

    public void serialize(Type var1, @Nullable T var2, ConfigurationNode var3) throws SerializationException;

    default public @Nullable T emptyValue(Type specificType, ConfigurationOptions options) {
        return null;
    }

    default public @Nullable T emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
        return this.emptyValue(specificType.getType(), options);
    }

    public static interface Annotated<V>
    extends TypeSerializer<V> {
        @Override
        public V deserialize(AnnotatedType var1, ConfigurationNode var2) throws SerializationException;

        @Override
        default public V deserialize(Type type, ConfigurationNode node) throws SerializationException {
            return this.deserialize(GenericTypeReflector.annotate((Type)type), node);
        }

        @Override
        public void serialize(AnnotatedType var1, @Nullable V var2, ConfigurationNode var3) throws SerializationException;

        @Override
        default public void serialize(Type type, @Nullable V obj, ConfigurationNode node) throws SerializationException {
            this.serialize(GenericTypeReflector.annotate((Type)type), obj, node);
        }

        @Override
        default public @Nullable V emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
            return null;
        }

        @Override
        default public @Nullable V emptyValue(Type specificType, ConfigurationOptions options) {
            return this.emptyValue(GenericTypeReflector.annotate((Type)specificType), options);
        }
    }
}

